/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.updater;

import com.openexchange.ajax.config.actions.SetRequest;
import com.openexchange.ajax.config.actions.Tree;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.updater.actions.FileRequest;
import com.openexchange.ajax.updater.actions.FileResponse;
import com.openexchange.ajax.updater.actions.UpdateXMLRequest;
import com.openexchange.ajax.updater.actions.UpdateXMLResponse;
import com.openexchange.configuration.AJAXConfig;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.codec.binary.Hex;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.cookie.Cookie;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class UpdaterXMLTest
extends AbstractAJAXSession {
    private AJAXClient client;
    private String userName;
    private String password;
    private String hostname;
    private String context;
    private String login;
    private HttpHost targetHost;

    public UpdaterXMLTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        AJAXClient.User user = AJAXClient.User.User1;
        this.userName = AJAXConfig.getProperty(user.getLogin());
        this.context = AJAXConfig.getProperty(AJAXConfig.Property.CONTEXTNAME);
        this.login = this.userName + '@' + this.context;
        this.password = AJAXConfig.getProperty(user.getPassword());
        this.hostname = AJAXConfig.getProperty(AJAXConfig.Property.HOSTNAME);
        this.targetHost = new HttpHost(this.hostname, 80);
        this.client = new AJAXClient(user);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBasicAuth() throws Exception {
        DefaultHttpClient httpClient = new DefaultHttpClient();
        try {
            HttpGet getXML = new HttpGet("/ajax/updater/update.xml");
            HttpResponse response = httpClient.execute(this.targetHost, (HttpRequest)getXML);
            HttpEntity entity = response.getEntity();
            EntityUtils.consume((HttpEntity)entity);
            UpdaterXMLTest.assertTrue((String)"Expected 401.", (response.getStatusLine().getStatusCode() == 401 ? 1 : 0) != 0);
            httpClient.getCredentialsProvider().setCredentials(new AuthScope(this.targetHost.getHostName(), this.targetHost.getPort()), (Credentials)new UsernamePasswordCredentials(this.login, this.password));
            response = httpClient.execute(this.targetHost, (HttpRequest)getXML);
            entity = response.getEntity();
            EntityUtils.consume((HttpEntity)entity);
            UpdaterXMLTest.assertTrue((String)"Expected 200.", (response.getStatusLine().getStatusCode() == 200 ? 1 : 0) != 0);
            List cookies = httpClient.getCookieStore().getCookies();
            boolean foundCookie = false;
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals("sessionid")) continue;
                foundCookie = true;
                break;
            }
            UpdaterXMLTest.assertTrue((String)"Did not find sessionid cookie.", (boolean)foundCookie);
            httpClient.getCredentialsProvider().clear();
            response = httpClient.execute(this.targetHost, (HttpRequest)getXML);
            entity = response.getEntity();
            EntityUtils.consume((HttpEntity)entity);
            UpdaterXMLTest.assertTrue((String)"Expected 401.", (response.getStatusLine().getStatusCode() == 401 ? 1 : 0) != 0);
        }
        finally {
            httpClient.getConnectionManager().shutdown();
        }
    }

    public void testUpdateXML() throws Exception {
        DefaultHttpClient httpClient = this.client.getSession().getHttpClient();
        httpClient.getCredentialsProvider().setCredentials(new AuthScope(this.targetHost.getHostName(), this.targetHost.getPort()), (Credentials)new UsernamePasswordCredentials(this.login, this.password));
        UpdateXMLRequest request = new UpdateXMLRequest();
        UpdateXMLResponse response = this.client.execute(request);
        SAXBuilder builder = new SAXBuilder();
        String xml = response.getXML();
        Document doc = null;
        try {
            doc = builder.build((Reader)new StringReader(xml));
            Element products = doc.getRootElement();
            List children = products.getChildren("Product");
            HashMap<String, String> filesToGet = new HashMap<String, String>();
            boolean foundAppsuiteLinkProduct = false;
            for (Element child : children) {
                if ("{92406A45-8205-4EF4-B7BF-8CA57D56B822}".equals(child.getChildText("UpgradeCode"))) {
                    foundAppsuiteLinkProduct = true;
                    continue;
                }
                filesToGet.put(child.getChildText("URL"), child.getChildText("MD5"));
            }
            for (String url : filesToGet.keySet()) {
                FileRequest fileRequest = new FileRequest(this.extractFileName(url));
                FileResponse fileResponse = this.client.execute(fileRequest);
                byte[] fileBytes = fileResponse.getFileBytes();
                String md5 = this.calculateMD5(new ByteArrayInputStream(fileBytes));
                UpdaterXMLTest.assertEquals((String)("MD5 Hash was not correct for Download from " + url), (String)md5, (String)((String)filesToGet.get(url)));
            }
        }
        catch (JDOMException e) {
            System.out.println(xml);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAgainWithChangedLocale() throws Exception {
        SetRequest setRequest = new SetRequest(Tree.Language, "wx_YZ");
        this.client.execute(setRequest);
        try {
            this.testUpdateXML();
        }
        finally {
            SetRequest setBackRequest = new SetRequest(Tree.Language, "en_US");
            this.client.execute(setBackRequest);
        }
    }

    private String extractFileName(String url) {
        String searchStr = "/ajax/updater/files/";
        return url.substring(url.indexOf(searchStr) + searchStr.length());
    }

    private String calculateMD5(InputStream inputStream) throws IOException {
        MessageDigest digest;
        if (inputStream == null) {
            return null;
        }
        try {
            digest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            IOException e1 = new IOException(e.getMessage());
            e1.initCause(e);
            throw e1;
        }
        int length = -1;
        byte[] buf = new byte[512];
        while ((length = inputStream.read(buf)) != -1) {
            digest.update(buf, 0, length);
        }
        return new String(Hex.encodeHex((byte[])digest.digest()));
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
    }
}

