/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.task;

import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.participant.ParticipantTools;
import com.openexchange.ajax.task.AbstractTaskTest;
import com.openexchange.ajax.task.actions.DeleteRequest;
import com.openexchange.ajax.task.actions.GetRequest;
import com.openexchange.ajax.task.actions.GetResponse;
import com.openexchange.ajax.task.actions.InsertRequest;
import com.openexchange.ajax.task.actions.InsertResponse;
import com.openexchange.ajax.task.actions.UpdateRequest;
import com.openexchange.ajax.task.actions.UpdateResponse;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.Participant;
import com.openexchange.groupware.container.UserParticipant;
import com.openexchange.groupware.tasks.Create;
import com.openexchange.groupware.tasks.Task;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.TimeZone;
import org.json.JSONException;
import org.xml.sax.SAXException;

public final class Bug12926Test
extends AbstractTaskTest {
    private AJAXClient client;
    private int userId;
    private int folderId;
    private TimeZone tz;
    private Task task;

    public Bug12926Test(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.client = this.getClient();
        this.userId = this.client.getValues().getUserId();
        this.folderId = this.client.getValues().getPrivateTaskFolder();
        this.tz = this.client.getValues().getTimeZone();
        this.task = Create.createWithDefaults(this.folderId, "Bug 12926 test task");
        List<Participant> participants = ParticipantTools.getParticipants(this.client, 1, this.userId);
        participants.add((Participant)new UserParticipant(this.userId));
        this.task.setParticipants(participants);
        InsertResponse insertR = this.client.execute(new InsertRequest(this.task, this.tz));
        insertR.fillTask(this.task);
    }

    @Override
    protected void tearDown() throws Exception {
        this.client.execute(new DeleteRequest(this.task));
        super.tearDown();
    }

    public void testTaskStaysInDelegatorFolder() throws OXException, IOException, SAXException, JSONException {
        Task task2 = new Task();
        task2.setObjectID(this.task.getObjectID());
        task2.setParentFolderID(this.task.getParentFolderID());
        task2.setLastModified(this.task.getLastModified());
        ArrayList<Participant> participants = new ArrayList<Participant>();
        for (Participant participant : this.task.getParticipants()) {
            if (participant.getIdentifier() == this.userId) continue;
            participants.add(participant);
        }
        task2.setParticipants(participants);
        UpdateResponse uResponse = this.client.execute(new UpdateRequest(this.task, this.tz));
        this.task.setLastModified(uResponse.getTimestamp());
        GetResponse getR = this.client.execute(new GetRequest(this.task.getParentFolderID(), this.task.getObjectID(), false));
        if (getR.hasError()) {
            Bug12926Test.fail((String)getR.getException().getMessage());
        }
    }
}

