/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.publish.actions;

import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.framework.AJAXRequest;
import com.openexchange.ajax.framework.AbstractAJAXParser;
import com.openexchange.ajax.publish.actions.AbstractPublicationRequest;
import com.openexchange.ajax.publish.actions.AllPublicationsResponse;
import com.openexchange.java.Strings;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.json.JSONException;

public class AllPublicationsRequest
extends AbstractPublicationRequest<AllPublicationsResponse> {
    private int id;
    private String Folder;
    private String entityModule;
    private List<String> columns;
    private Map<String, List<String>> dynamicColumns;

    public AllPublicationsRequest() {
    }

    public AllPublicationsRequest(String folder, int id, String entityModule, List<String> columns) {
        this();
        this.setId(id);
        this.setFolder(folder);
        this.setEntityModule(entityModule);
        this.setColumns(columns);
    }

    public AllPublicationsRequest(String folder, int id, String entityModule, List<String> columns, Map<String, List<String>> dynamicColumns) {
        this(folder, id, entityModule, columns);
        this.setDynamicColumns(dynamicColumns);
    }

    public AllPublicationsRequest(List<String> columns) {
        this(null, -1, null, columns);
    }

    public AllPublicationsRequest(int id, String entityModule, List<String> columns) {
        this(null, id, entityModule, columns);
    }

    public void setDynamicColumns(Map<String, List<String>> dynamicColumns) {
        this.dynamicColumns = dynamicColumns;
    }

    public Map<String, List<String>> getDynamicColumns() {
        return this.dynamicColumns;
    }

    public void setColumns(List<String> columns) {
        this.columns = columns;
    }

    public List<String> getColumns() {
        return this.columns;
    }

    public void setEntityModule(String entityModule) {
        this.entityModule = entityModule;
    }

    public String getEntityModule() {
        return this.entityModule;
    }

    public void setFolder(String folder) {
        this.Folder = folder;
    }

    public String getFolder() {
        return this.Folder;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    @Override
    public Object getBody() throws JSONException {
        return null;
    }

    @Override
    public AJAXRequest.Method getMethod() {
        return AJAXRequest.Method.GET;
    }

    @Override
    public AJAXRequest.Parameter[] getParameters() {
        LinkedList<AJAXRequest.Parameter> params = new LinkedList<AJAXRequest.Parameter>();
        params.add(new AJAXRequest.Parameter("action", "all"));
        if (this.getId() > -1) {
            params.add(new AJAXRequest.Parameter("id", this.getId()));
        }
        if (this.getFolder() != null) {
            params.add(new AJAXRequest.Parameter("folder", this.getFolder()));
        }
        if (this.getEntityModule() != null) {
            params.add(new AJAXRequest.Parameter("entityModule", this.getEntityModule()));
        }
        if (this.getColumns() != null) {
            params.add(new AJAXRequest.Parameter("columns", Strings.join(this.getColumns(), (String)",")));
        }
        if (this.getDynamicColumns() != null) {
            for (String plugin : this.getDynamicColumns().keySet()) {
                params.add(new AJAXRequest.Parameter(plugin, Strings.join((Collection)this.getDynamicColumns().get(plugin), (String)",")));
            }
        }
        return params.toArray(new AJAXRequest.Parameter[0]);
    }

    @Override
    public AbstractAJAXParser<? extends AllPublicationsResponse> getParser() {
        return new AbstractAJAXParser<AllPublicationsResponse>(this.isFailOnError()){

            @Override
            protected AllPublicationsResponse createResponse(Response response) throws JSONException {
                return new AllPublicationsResponse(response);
            }
        };
    }
}

