/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.mail;

import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.UserValues;
import com.openexchange.exception.OXException;
import java.io.IOException;
import org.json.JSONException;
import org.xml.sax.SAXException;

public enum MailFolder {
    INBOX("inbox"),
    DRAFTS("drafts"),
    SENT("sent"),
    TRASH("trash");

    private final String name;

    private MailFolder(String name) {
        this.name = name;
    }

    public static MailFolder getByName(String name) {
        MailFolder[] folders;
        for (MailFolder folder : folders = MailFolder.values()) {
            if (!name.equals(folder.name)) continue;
            return folder;
        }
        return null;
    }

    public String getFolder(AJAXClient client) throws OXException, IOException, SAXException, JSONException {
        UserValues values = client.getValues();
        switch (this) {
            case INBOX: {
                return values.getInboxFolder();
            }
            case DRAFTS: {
                return values.getDraftsFolder();
            }
            case SENT: {
                return values.getSentFolder();
            }
            case TRASH: {
                return values.getTrashFolder();
            }
        }
        return null;
    }
}

