/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.infostore.test;

import com.openexchange.ajax.infostore.test.AbstractInfostoreTest;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.infostore.DocumentMetadata;
import com.openexchange.groupware.infostore.database.impl.DocumentMetadataImpl;
import com.openexchange.test.TestInit;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import org.json.JSONException;
import org.xml.sax.SAXException;

public class CreateAndDeleteInfostoreTest
extends AbstractInfostoreTest {
    public CreateAndDeleteInfostoreTest(String name) {
        super(name);
    }

    public void testCreatingOneItem() throws OXException, IOException, SAXException, JSONException, OXException {
        FolderObject folder = this.generateInfostoreFolder("InfostoreCreateDeleteTest Folder");
        this.fMgr.insertFolderOnServer(folder);
        DocumentMetadataImpl expected = new DocumentMetadataImpl();
        expected.setCreationDate(new Date());
        expected.setFolderId((long)folder.getObjectID());
        expected.setTitle("InfostoreCreateDeleteTest Item");
        expected.setLastModified(new Date());
        this.infoMgr.newAction((DocumentMetadata)expected);
        CreateAndDeleteInfostoreTest.assertFalse((String)"Creating an entry should work", (boolean)this.infoMgr.getLastResponse().hasError());
        DocumentMetadata actual = this.infoMgr.getAction(expected.getId());
        CreateAndDeleteInfostoreTest.assertEquals((String)"Name should be the same", (String)expected.getTitle(), (String)actual.getTitle());
        this.infoMgr.deleteAction((DocumentMetadata)expected);
        CreateAndDeleteInfostoreTest.assertFalse((String)"Deleting an entry should work", (boolean)this.infoMgr.getLastResponse().hasError());
    }

    public void testCreatingOneItemWithFile() throws Exception {
        FolderObject folder = this.generateInfostoreFolder("InfostoreCreateDeleteTest Folder");
        this.fMgr.insertFolderOnServer(folder);
        DocumentMetadataImpl expected = new DocumentMetadataImpl();
        expected.setCreationDate(new Date());
        expected.setFolderId((long)folder.getObjectID());
        expected.setTitle("InfostoreCreateDeleteTest File");
        expected.setLastModified(new Date());
        new File(TestInit.getTestProperty("ajaxPropertiesFile"));
        this.infoMgr.newAction((DocumentMetadata)expected);
        CreateAndDeleteInfostoreTest.assertFalse((String)"Creating an entry should work", (boolean)this.infoMgr.getLastResponse().hasError());
        DocumentMetadata actual = this.infoMgr.getAction(expected.getId());
        CreateAndDeleteInfostoreTest.assertEquals((String)"Name should be the same", (String)expected.getTitle(), (String)actual.getTitle());
        this.infoMgr.deleteAction((DocumentMetadata)expected);
        CreateAndDeleteInfostoreTest.assertFalse((String)"Deleting an entry should work", (boolean)this.infoMgr.getLastResponse().hasError());
    }

    public void testCreatingTwoItemWithFiles() throws Exception {
        FolderObject folder = this.generateInfostoreFolder("InfostoreCreateDeleteTest Folder");
        this.fMgr.insertFolderOnServer(folder);
        DocumentMetadataImpl expected = new DocumentMetadataImpl();
        expected.setCreationDate(new Date());
        expected.setFolderId((long)folder.getObjectID());
        expected.setTitle("InfostoreCreateDeleteTest File1");
        expected.setLastModified(new Date());
        File file = new File(TestInit.getTestProperty("ajaxPropertiesFile"));
        this.infoMgr.newAction((DocumentMetadata)expected, file);
        CreateAndDeleteInfostoreTest.assertFalse((String)"Creating an entry should work", (boolean)this.infoMgr.getLastResponse().hasError());
        DocumentMetadata actual = this.infoMgr.getAction(expected.getId());
        CreateAndDeleteInfostoreTest.assertEquals((String)"Name should be the same", (String)expected.getTitle(), (String)actual.getTitle());
        expected = new DocumentMetadataImpl();
        expected.setCreationDate(new Date());
        expected.setFolderId((long)folder.getObjectID());
        expected.setTitle("InfostoreCreateDeleteTest File2");
        expected.setLastModified(new Date());
        file = new File(TestInit.getTestProperty("webdavPropertiesFile"));
        this.infoMgr.newAction((DocumentMetadata)expected, file);
        CreateAndDeleteInfostoreTest.assertFalse((String)"Creating an entry should work", (boolean)this.infoMgr.getLastResponse().hasError());
        actual = this.infoMgr.getAction(expected.getId());
        CreateAndDeleteInfostoreTest.assertEquals((String)"Name should be the same", (String)expected.getTitle(), (String)actual.getTitle());
    }
}

