/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.importexport;

import com.openexchange.ajax.appointment.recurrence.ManagedAppointmentTest;
import com.openexchange.ajax.framework.AJAXRequest;
import com.openexchange.ajax.framework.AbstractAJAXParser;
import com.openexchange.ajax.importexport.actions.AbstractImportRequest;
import com.openexchange.ajax.importexport.actions.ICalImportParser;
import com.openexchange.ajax.importexport.actions.ICalImportRequest;
import com.openexchange.ajax.importexport.actions.ICalImportResponse;
import com.openexchange.java.Charsets;
import com.openexchange.tools.arrays.Arrays;
import java.io.ByteArrayInputStream;
import java.nio.charset.Charset;
import java.util.UUID;

public class Bug28071Test
extends ManagedAppointmentTest {
    private static final String ICAL = "BEGIN:VCALENDAR\nPRODID:-//afklm/Manage My Booking/NONSGML v1.0//EN\nVERSION:2.0\nCALSCALE:GREGORIAN\nMETHOD:PUBLISH\nBEGIN:VEVENT\nDTSTAMP:20130806T090731Z\nDTSTART:20130806T182000\nDTEND:20130806T194500\nSUMMARY:Flug KL1888 N\u00fcrnberg - Amsterdam\\, Abflug 18:20 Ortszeit\nUID:${UID1}\nLOCATION:N\u00fcrnberg (N\u00fcrnberg)\nDESCRIPTION:Ihr Flug KL1888 von N\u00fcrnberg (N\u00fcrnberg) nach Amsterdam (Schiphol) wird um 18:20 Ortszeit starten\\n\\nMeine Buchung verwalten auf KLM.com: https://www.klm.com/travel/DE_DE/index.htm#tab=db_mmb\\n\\nBei Fragen zu Ihrer Reservierung kontaktieren Sie bitte das KLM-Servicecenter: http://www.klm.com/travel/DE_DE/customer_support/customer_support/contact/contact_popup.htm\\n\\nHaftungsausschluss: Bei den genannten Zeiten handelt es sich um Ortszeiten. Abflugzeiten k\u00f6nnen \u00c4nderungen unterliegen. \u00dcberpr\u00fcfen Sie vor Ihrem Flug immer die tats\u00e4chliche Abflugzeit.\nURL:https://www.klm.com/travel/DE_DE/index.htm#tab=db_mmb\nTRANSP:TRANSPARENT\nEND:VEVENT\nBEGIN:VEVENT\nDTSTAMP:20130806T090731Z\nDTSTART:20130808T163000\nDTEND:20130808T174000\nSUMMARY:Flug KL1887 Amsterdam - N\u00fcrnberg\\, Abflug 16:30 Ortszeit\nUID:${UID2}\nLOCATION:Amsterdam (Schiphol)\nDESCRIPTION:Ihr Flug KL1887 von Amsterdam (Schiphol) nach N\u00fcrnberg (N\u00fcrnberg) wird um 16:30 Ortszeit starten\\n\\nMeine Buchung verwalten auf KLM.com: https://www.klm.com/travel/DE_DE/index.htm#tab=db_mmb\\n\\nCheck-in: https://www.klm.com/travel/DE_DE/prepare_for_travel/checkin_options/internet_checkin/ici_jffp_app.htm\\n\\nBei Fragen zu Ihrer Reservierung kontaktieren Sie bitte das KLM-Servicecenter: http://www.klm.com/travel/DE_DE/customer_support/customer_support/contact/contact_popup.htm\\n\\nHaftungsausschluss: Bei den genannten Zeiten handelt es sich um Ortszeiten. Abflugzeiten k\u00f6nnen \u00c4nderungen unterliegen. \u00dcberpr\u00fcfen Sie vor Ihrem Flug immer die tats\u00e4chliche Abflugzeit.\nURL:https://www.klm.com/travel/DE_DE/index.htm#tab=db_mmb\nTRANSP:TRANSPARENT\nEND:VEVENT\nBEGIN:VEVENT\nDTSTAMP:20130806T090731Z\nDTSTART:20130807T103000\nDTEND:20130807T103000\nSUMMARY:Check-in f\u00fcr Flug KL1887 Amsterdam - N\u00fcrnberg ist jetzt ge\u00f6ffnet\nUID:${UID3}\nLOCATION:Amsterdam (Schiphol)\nDESCRIPTION:Sie k\u00f6nnen jetzt f\u00fcr Ihren Flug von Amsterdam nach N\u00fcrnberg einchecken.\\n\\nOnline einchecken: https://www.klm.com/travel/DE_DE/prepare_for_travel/checkin_options/internet_checkin/ici_jffp_app.htm.\\n\\nHaftungsausschluss: Bei den genannten Zeiten handelt es sich um Ortszeiten. Abflugzeiten k\u00f6nnen \u00c4nderungen unterliegen. \u00dcberpr\u00fcfen Sie vor Ihrem Flug immer die tats\u00e4chliche Abflugzeit.\nURL:https://www.klm.com/travel/DE_DE/index.htm#tab=db_mmb\nTRANSP:TRANSPARENT\nBEGIN:VALARM\nTRIGGER:PT0S\nACTION:DISPLAY\nDESCRIPTION:Check-in f\u00fcr Flug KL1887 Amsterdam - N\u00fcrnberg ist jetzt ge\u00f6ffnet\nEND:VALARM\nEND:VEVENT\nEND:VCALENDAR\n";

    public Bug28071Test(String name) {
        super(name);
    }

    public void testIgnoreUIDs() throws Exception {
        int i;
        String iCal = Bug28071Test.prepareICal();
        ICalImportResponse icalResponse = this.getClient().execute(new ICalImportRequest(this.folder.getObjectID(), iCal, false));
        Bug28071Test.assertFalse((String)"Initial import failed", (boolean)icalResponse.hasError());
        Bug28071Test.assertNotNull((String)"Should have processed 3 appointments", (Object)icalResponse.getImports());
        Bug28071Test.assertEquals((String)"Should have processed 3 appointments", (int)3, (int)icalResponse.getImports().length);
        for (i = 0; i < 3; ++i) {
            Bug28071Test.assertFalse((String)"Expected no error", (boolean)icalResponse.getImports()[i].hasError());
        }
        icalResponse = this.getClient().execute(new ICalImportRequest(this.folder.getObjectID(), iCal, false));
        Bug28071Test.assertTrue((String)"Expected UID conflict", (boolean)icalResponse.hasError());
        Bug28071Test.assertNotNull((String)"Should have processed 3 appointments", (Object)icalResponse.getImports());
        Bug28071Test.assertEquals((String)"Should have processed 3 appointments", (int)3, (int)icalResponse.getImports().length);
        for (i = 0; i < 3; ++i) {
            Bug28071Test.assertTrue((String)"Expected an error", (boolean)icalResponse.getImports()[i].hasError());
        }
        icalResponse = this.getClient().execute(new IgnoringUIDsImportRequest(iCal, this.folder.getObjectID()));
        Bug28071Test.assertFalse((String)"Import ignoring UIDs failed", (boolean)icalResponse.hasError());
        Bug28071Test.assertNotNull((String)"Should have processed 3 appointments", (Object)icalResponse.getImports());
        Bug28071Test.assertEquals((String)"Should have processed 3 appointments", (int)3, (int)icalResponse.getImports().length);
        for (i = 0; i < 3; ++i) {
            Bug28071Test.assertFalse((String)"Expected no error", (boolean)icalResponse.getImports()[i].hasError());
        }
    }

    private static String prepareICal() {
        return ICAL.replaceAll("\\$\\{UID1\\}", UUID.randomUUID().toString()).replaceAll("\\$\\{UID2\\}", UUID.randomUUID().toString()).replaceAll("\\$\\{UID3\\}", UUID.randomUUID().toString());
    }

    private static final class IgnoringUIDsImportRequest
    extends AbstractImportRequest<ICalImportResponse> {
        public IgnoringUIDsImportRequest(String iCal, int folderID) {
            super(AbstractImportRequest.Action.ICal, folderID, new ByteArrayInputStream(Charsets.getBytes((String)iCal, (Charset)Charsets.UTF_8)));
        }

        @Override
        public AbstractAJAXParser<? extends ICalImportResponse> getParser() {
            return new ICalImportParser(true);
        }

        @Override
        public AJAXRequest.Parameter[] getParameters() {
            Object[] parameters = super.getParameters();
            return (AJAXRequest.Parameter[])Arrays.add((Object[])parameters, (Object[])new AJAXRequest.Parameter[]{new AJAXRequest.Parameter("ignoreUIDs", "true")});
        }
    }
}

