/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.framework;

import com.openexchange.ajax.fields.OrderFields;
import com.openexchange.ajax.framework.AJAXRequest;
import com.openexchange.ajax.framework.AbstractColumnsResponse;
import com.openexchange.ajax.framework.Header;
import com.openexchange.groupware.search.Order;
import java.util.ArrayList;
import java.util.Date;

public abstract class AbstractUpdatesRequest<T extends AbstractColumnsResponse>
implements AJAXRequest<T> {
    private final String servletPath;
    private final int folderId;
    private final int[] columns;
    private final int sort;
    private final Order order;
    private final Date lastModified;
    private final Ignore ignore;
    private final boolean failOnError;

    public AbstractUpdatesRequest(String servletPath, int folderId, int[] columns, int sort, Order order, Date lastModified, boolean failOnError) {
        this(servletPath, folderId, columns, sort, order, lastModified, Ignore.DELETED, failOnError);
    }

    public AbstractUpdatesRequest(String servletPath, int folderId, int[] columns, int sort, Order order, Date lastModified, Ignore ignore, boolean failOnError) {
        this.servletPath = servletPath;
        this.folderId = folderId;
        this.columns = columns;
        this.sort = sort;
        this.order = order;
        this.lastModified = lastModified;
        this.ignore = ignore;
        this.failOnError = failOnError;
    }

    @Override
    public String getServletPath() {
        return this.servletPath;
    }

    @Override
    public Object getBody() {
        return null;
    }

    @Override
    public AJAXRequest.Method getMethod() {
        return AJAXRequest.Method.GET;
    }

    @Override
    public Header[] getHeaders() {
        return NO_HEADER;
    }

    @Override
    public AJAXRequest.Parameter[] getParameters() {
        ArrayList<AJAXRequest.Parameter> params = new ArrayList<AJAXRequest.Parameter>();
        params.add(new AJAXRequest.Parameter("action", "updates"));
        if (-1 != this.folderId) {
            params.add(new AJAXRequest.Parameter("folder", this.folderId));
        }
        params.add(new AJAXRequest.Parameter("columns", this.getColumns()));
        if (null != this.order) {
            params.add(new AJAXRequest.Parameter("sort", this.sort));
            params.add(new AJAXRequest.Parameter("order", OrderFields.write((Order)this.order)));
        }
        params.add(new AJAXRequest.Parameter("timestamp", this.lastModified));
        params.add(new AJAXRequest.Parameter("ignore", this.ignore.getValue()));
        return params.toArray(new AJAXRequest.Parameter[params.size()]);
    }

    public int[] getColumns() {
        return this.columns;
    }

    public boolean isFailOnError() {
        return this.failOnError;
    }

    public static enum Ignore {
        DELETED("deleted"),
        NONE("none");

        private final String value;

        private Ignore(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

