/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.contact;

import com.openexchange.ajax.contact.action.DeleteRequest;
import com.openexchange.ajax.contact.action.InsertRequest;
import com.openexchange.ajax.contact.action.InsertResponse;
import com.openexchange.ajax.contact.action.SearchRequest;
import com.openexchange.ajax.contact.action.SearchResponse;
import com.openexchange.ajax.folder.Create;
import com.openexchange.ajax.folder.actions.API;
import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.container.DataObject;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.search.ContactSearchObject;
import java.util.Date;

public class SearchInAllContactFoldersTest
extends AbstractAJAXSession {
    private AJAXClient client;
    private Contact contact1;
    private Contact contact2;
    private FolderObject newFolder;

    public SearchInAllContactFoldersTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.client = this.getClient();
        this.newFolder = Create.createPublicFolder(this.client, "SearchInAllFoldersTest (" + new Date().getTime() + ")", 3);
        this.contact1 = new Contact();
        this.contact1.setDisplayName("Herbert Meier");
        this.contact1.setSurName("Meier");
        this.contact1.setGivenName("Herbert");
        this.contact1.setDisplayName("Herbert Meier");
        this.contact1.setEmail1("herbert.meier@example.com");
        this.contact1.setParentFolderID(this.client.getValues().getPrivateContactFolder());
        InsertRequest insertContact1 = new InsertRequest(this.contact1);
        InsertResponse insertResponse = this.client.execute(insertContact1);
        insertResponse.fillObject((DataObject)this.contact1);
        this.contact2 = new Contact();
        this.contact2.setDisplayName("Herbert M\u00fcller");
        this.contact2.setSurName("M\u00fcller");
        this.contact2.setGivenName("Herbert");
        this.contact2.setEmail1("herbert.mueller@example.com");
        this.contact2.setParentFolderID(this.newFolder.getObjectID());
        InsertRequest insertContact2 = new InsertRequest(this.contact2);
        insertResponse = this.client.execute(insertContact2);
        insertResponse.fillObject((DataObject)this.contact2);
    }

    @Override
    public void tearDown() throws Exception {
        DeleteRequest contactDeleteRequest = new DeleteRequest(this.contact1);
        this.client.execute(contactDeleteRequest);
        contactDeleteRequest = new DeleteRequest(this.contact2);
        this.client.execute(contactDeleteRequest);
        com.openexchange.ajax.folder.actions.DeleteRequest folderDeleteRequest = new com.openexchange.ajax.folder.actions.DeleteRequest((API)EnumAPI.OX_OLD, this.newFolder);
        this.client.execute(folderDeleteRequest);
        super.tearDown();
    }

    public void testAllContactFoldersSearch() throws Throwable {
        int[] columns = new int[]{1};
        ContactSearchObject cso = new ContactSearchObject();
        cso.setGivenName("Herbert");
        SearchRequest searchRequest = new SearchRequest(cso, columns, true);
        SearchResponse searchResponse = this.client.execute(searchRequest);
        this.assertFoundContacts(searchResponse);
    }

    public void testAutoCompleteSearchForAllFolders() throws Throwable {
        int[] columns = new int[]{1, 20, 500, 524, 555, 556, 557, 592, 602};
        ContactSearchObject cso = new ContactSearchObject();
        cso.setDisplayName("herb*");
        cso.setEmail1("herb*");
        cso.setEmail2("herb*");
        cso.setEmail3("herb*");
        cso.setDisplayName("herb*");
        cso.setDisplayName("herb*");
        cso.setEmailAutoComplete(true);
        cso.setOrSearch(true);
        SearchRequest request = new SearchRequest(cso, columns, 609, null);
        SearchResponse response = this.client.execute(request);
        this.assertFoundContacts(response);
    }

    private void assertFoundContacts(SearchResponse response) {
        boolean foundFirst = false;
        boolean foundSecond = false;
        int idPos = response.getColumnPos(1);
        for (Object[] obj : response) {
            if (this.contact1.getObjectID() == ((Integer)obj[idPos]).intValue()) {
                foundFirst = true;
            }
            if (this.contact2.getObjectID() != ((Integer)obj[idPos]).intValue()) continue;
            foundSecond = true;
        }
        SearchInAllContactFoldersTest.assertTrue((String)"Search did not return first inserted contact.", (boolean)foundFirst);
        SearchInAllContactFoldersTest.assertTrue((String)"Search did not return second inserted contact.", (boolean)foundSecond);
    }
}

