/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment.recurrence;

import com.openexchange.ajax.appointment.action.AppointmentInsertResponse;
import com.openexchange.ajax.appointment.action.DeleteRequest;
import com.openexchange.ajax.appointment.action.InsertRequest;
import com.openexchange.ajax.appointment.action.UpdateRequest;
import com.openexchange.ajax.appointment.action.UpdateResponse;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import java.util.Calendar;
import java.util.TimeZone;
import org.json.JSONException;
import org.json.JSONObject;

public final class Bug12496Test
extends AbstractAJAXSession {
    private TimeZone tz;
    private int folderId;
    private Appointment appointment;

    public Bug12496Test(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        AJAXClient client = this.getClient();
        this.tz = client.getValues().getTimeZone();
        this.folderId = client.getValues().getPrivateAppointmentFolder();
        this.appointment = this.createAppointment();
        InsertRequest request = new InsertRequest(this.appointment, this.tz);
        AppointmentInsertResponse response = client.execute(request);
        response.fillAppointment(this.appointment);
    }

    @Override
    protected void tearDown() throws Exception {
        DeleteRequest request = new DeleteRequest(this.appointment);
        this.getClient().execute(request);
        super.tearDown();
    }

    public void testDailyFullTimeUntil() throws Throwable {
        AJAXClient client = this.getClient();
        Appointment changed = this.changeAppointment();
        SpecialUpdateRequest request = new SpecialUpdateRequest(changed, this.tz);
        UpdateResponse response = client.execute(request);
        this.appointment.setLastModified(response.getTimestamp());
    }

    private Appointment createAppointment() {
        Calendar calendar = TimeTools.createCalendar(TimeZone.getTimeZone("UTC"));
        Appointment appointment = new Appointment();
        appointment.setTitle("test for bug 12496");
        appointment.setParentFolderID(this.folderId);
        calendar.set(11, 0);
        appointment.setStartDate(calendar.getTime());
        calendar.add(5, 1);
        appointment.setEndDate(calendar.getTime());
        appointment.setFullTime(true);
        appointment.setIgnoreConflicts(true);
        appointment.setRecurrenceType(1);
        appointment.setInterval(1);
        appointment.setOccurrence(2);
        return appointment;
    }

    private Appointment changeAppointment() {
        Calendar calendar = TimeTools.createCalendar(this.tz);
        Appointment changed = new Appointment();
        changed.setTitle("test for bug 12496 changed");
        changed.setParentFolderID(this.folderId);
        changed.setObjectID(this.appointment.getObjectID());
        changed.setLastModified(this.appointment.getLastModified());
        changed.setStartDate(calendar.getTime());
        calendar.add(11, 1);
        changed.setFullTime(false);
        changed.setEndDate(calendar.getTime());
        changed.setUntil(null);
        return changed;
    }

    private static final class SpecialUpdateRequest
    extends UpdateRequest {
        public SpecialUpdateRequest(Appointment appointment, TimeZone tz) {
            super(appointment, tz);
        }

        @Override
        public JSONObject getBody() throws JSONException {
            JSONObject retval = super.getBody();
            retval.put("until", JSONObject.NULL);
            return retval;
        }
    }
}

