/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.threadpool.osgi;

import com.openexchange.log.Log;
import com.openexchange.session.Session;
import com.openexchange.session.SessionThreadCounter;
import com.openexchange.session.ThreadCountEntry;
import com.openexchange.sessionCount.SessionThreadCounterImpl;
import com.openexchange.sessiond.SessiondService;
import java.util.Set;
import org.osgi.framework.BundleContext;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.osgi.util.tracker.ServiceTracker;

public final class SessionThreadCountEventHandler
extends ServiceTracker<SessiondService, SessiondService>
implements EventHandler {
    private static final org.apache.commons.logging.Log LOG = Log.loggerFor(SessionThreadCountEventHandler.class);
    private final SessionThreadCounterImpl counterImpl;
    private final int threshold;

    public SessionThreadCountEventHandler(BundleContext context, int threshold, SessionThreadCounterImpl counterImpl) {
        super(context, SessiondService.class, null);
        this.counterImpl = counterImpl;
        this.threshold = threshold;
    }

    public void handleEvent(Event event) {
        Set threads = ((ThreadCountEntry)event.getProperty(SessionThreadCounter.EVENT_PROP_ENTRY)).getThreads();
        int num = threads.size();
        if (num < this.threshold) {
            return;
        }
        SessiondService sessiondService = (SessiondService)this.getService();
        if (null == sessiondService) {
            return;
        }
        String sessionId = (String)event.getProperty(SessionThreadCounter.EVENT_PROP_SESSION_ID);
        Session session = sessiondService.getSession(sessionId);
        if (null == session) {
            this.counterImpl.remove(sessionId);
            return;
        }
        StringBuilder info = new StringBuilder(1024);
        String lineSeparator = System.getProperty("line.separator");
        info.append("Detected ").append(num).append(" threads belonging to session \"").append(sessionId);
        info.append("\" (user=").append(session.getUserId()).append(", context=").append(session.getContextId()).append("):").append(lineSeparator);
        for (Thread thread : threads) {
            info.append(lineSeparator).append("--------------------------------------------------------------------------").append(lineSeparator);
            SessionThreadCountEventHandler.appendStackTrace(thread.getStackTrace(), info, lineSeparator);
        }
        LOG.warn((Object)info.toString());
    }

    private static void appendStackTrace(StackTraceElement[] trace, StringBuilder sb, String lineSeparator) {
        if (null == trace) {
            sb.append("<missing stack trace>\n");
            return;
        }
        for (StackTraceElement ste : trace) {
            String className = ste.getClassName();
            if (null == className) continue;
            sb.append("    at ").append(className).append('.').append(ste.getMethodName());
            if (ste.isNativeMethod()) {
                sb.append("(Native Method)");
            } else {
                String fileName = ste.getFileName();
                if (null == fileName) {
                    sb.append("(Unknown Source)");
                } else {
                    int lineNumber = ste.getLineNumber();
                    sb.append('(').append(fileName);
                    if (lineNumber >= 0) {
                        sb.append(':').append(lineNumber);
                    }
                    sb.append(')');
                }
            }
            sb.append(lineSeparator);
        }
    }
}

