/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.threadpool;

import com.openexchange.exception.OXException;
import com.openexchange.log.LogFactory;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;

public abstract class RunLoop<E>
implements Runnable {
    private static final Log LOG = LogFactory.getLog(RunLoop.class);
    protected final BlockingQueue<E> queue = new LinkedBlockingDeque();
    private final String name;
    private AtomicBoolean isPaused = new AtomicBoolean();
    private Lock handleLock = new ReentrantLock();
    private Condition proceedCondition = this.handleLock.newCondition();
    protected E currentElement;

    public RunLoop(String name) {
        this.name = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Thread.currentThread().setName(this.name);
        while (true) {
            try {
                this.currentElement = this.queue.take();
            }
            catch (InterruptedException ie) {
                LOG.info((Object)"Returning from RunLoop due to interruption");
                return;
            }
            try {
                this.handleLock.lock();
                while (this.isPaused.get()) {
                    this.proceedCondition.await();
                }
                if (null == this.currentElement) continue;
                this.handle(this.currentElement);
                continue;
            }
            catch (InterruptedException e) {
                LOG.info((Object)"Returning from RunLoop due to interruption");
                return;
            }
            catch (Throwable t) {
                LOG.error((Object)t.getMessage(), t);
                continue;
            }
            finally {
                this.handleLock.unlock();
                continue;
            }
            break;
        }
    }

    public boolean offer(E element) {
        return this.queue.offer(element);
    }

    protected void pauseHandling() {
        this.isPaused.set(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void continueHandling() {
        try {
            this.handleLock.lock();
            this.isPaused.set(false);
            this.proceedCondition.signalAll();
        }
        finally {
            this.handleLock.unlock();
        }
    }

    protected abstract void handle(E var1) throws OXException;
}

