/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.sessionCount;

import com.openexchange.session.Session;
import com.openexchange.session.SessionThreadCounter;
import com.openexchange.sessionCount.SessionThreadCountMBean;
import com.openexchange.sessiond.SessiondService;
import java.util.Map;
import java.util.Set;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;
import org.osgi.util.tracker.ServiceTracker;

public final class SessionThreadCountMBeanImpl
extends StandardMBean
implements SessionThreadCountMBean {
    private final SessionThreadCounter counter;
    private final ServiceTracker<SessiondService, SessiondService> sessiondServiceTracker;

    public SessionThreadCountMBeanImpl(SessionThreadCounter counter, ServiceTracker<SessiondService, SessiondService> sessiondServiceTracker) throws NotCompliantMBeanException {
        super(SessionThreadCountMBean.class);
        this.counter = counter;
        this.sessiondServiceTracker = sessiondServiceTracker;
    }

    @Override
    public String getThreads(int threshold) {
        StringBuilder info = new StringBuilder(8192);
        SessiondService service = (SessiondService)this.sessiondServiceTracker.getService();
        Map threads = this.counter.getThreads(threshold);
        String lineSeparator = System.getProperty("line.separator");
        for (Map.Entry entry : threads.entrySet()) {
            Set set = (Set)entry.getValue();
            info.append(lineSeparator).append(lineSeparator).append(set.size()).append(" threads belonging to session \"").append((String)entry.getKey());
            if (null == service) {
                info.append("\":").append(lineSeparator);
            } else {
                Session session = service.getSession((String)entry.getKey());
                if (null == session) {
                    info.append("\":").append(lineSeparator);
                } else {
                    info.append("\" (user=").append(session.getUserId()).append(", context=").append(session.getContextId()).append("):").append(lineSeparator);
                }
            }
            for (Thread thread : set) {
                info.append(lineSeparator).append("--------------------------------------------------------------------------").append(lineSeparator);
                SessionThreadCountMBeanImpl.appendStackTrace(thread.getStackTrace(), info, lineSeparator);
            }
        }
        return info.toString();
    }

    private static void appendStackTrace(StackTraceElement[] trace, StringBuilder sb, String lineSeparator) {
        if (null == trace) {
            sb.append("<missing stack trace>").append(lineSeparator);
            return;
        }
        for (StackTraceElement ste : trace) {
            String className = ste.getClassName();
            if (null == className) continue;
            sb.append("    at ").append(className).append('.').append(ste.getMethodName());
            if (ste.isNativeMethod()) {
                sb.append("(Native Method)");
            } else {
                String fileName = ste.getFileName();
                if (null == fileName) {
                    sb.append("(Unknown Source)");
                } else {
                    int lineNumber = ste.getLineNumber();
                    sb.append('(').append(fileName);
                    if (lineNumber >= 0) {
                        sb.append(':').append(lineNumber);
                    }
                    sb.append(')');
                }
            }
            sb.append(lineSeparator);
        }
    }
}

