/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.log.internal;

import com.openexchange.log.LogProperties;
import com.openexchange.log.Loggable;
import com.openexchange.log.ReportedThrowable;
import com.openexchange.log.ReportedThrowableHandler;
import com.openexchange.log.internal.callback.DebugCallback;
import com.openexchange.log.internal.callback.ErrorCallback;
import com.openexchange.log.internal.callback.FatalCallback;
import com.openexchange.log.internal.callback.InfoCallback;
import com.openexchange.log.internal.callback.LogCallback;
import com.openexchange.log.internal.callback.TraceCallback;
import com.openexchange.log.internal.callback.WarnCallback;
import com.openexchange.osgi.NearRegistryServiceTracker;
import com.openexchange.threadpool.AbstractTask;
import com.openexchange.threadpool.ThreadRenamer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

final class LoggerTask
extends AbstractTask<Object> {
    private static final String PREFIX = "Logged at: ";
    private static final Loggable POISON = new Loggable(){

        public Throwable getThrowable() {
            return null;
        }

        public Object getMessage() {
            return null;
        }

        public Log getLog() {
            return null;
        }

        public Loggable.Level getLevel() {
            return null;
        }

        public StackTraceElement[] getCallerTrace() {
            return null;
        }

        public boolean isLoggable() {
            return false;
        }

        public Map<LogProperties.Name, Object> properties() {
            return Collections.emptyMap();
        }
    };
    private final BlockingQueue<Loggable> queue;
    private final AtomicBoolean keepgoing;
    private final String lineSeparator = System.getProperty("line.separator");
    private final int maxMessageLength;
    private final NearRegistryServiceTracker<ReportedThrowableHandler> registry;
    private final Map<Loggable.Level, LogCallback> callbacks;
    private static final Pattern CRLF = Pattern.compile("\r?\n");

    protected LoggerTask(BlockingQueue<Loggable> queue, int maxMessageLength, NearRegistryServiceTracker<ReportedThrowableHandler> registry) {
        this.keepgoing = new AtomicBoolean(true);
        this.queue = queue;
        this.maxMessageLength = maxMessageLength;
        this.registry = registry;
        EnumMap<Loggable.Level, LogCallback> callbacks = new EnumMap<Loggable.Level, LogCallback>(Loggable.Level.class);
        callbacks.put(Loggable.Level.DEBUG, new DebugCallback());
        callbacks.put(Loggable.Level.ERROR, new ErrorCallback());
        callbacks.put(Loggable.Level.FATAL, new FatalCallback());
        callbacks.put(Loggable.Level.INFO, new InfoCallback());
        callbacks.put(Loggable.Level.TRACE, new TraceCallback());
        callbacks.put(Loggable.Level.WARNING, new WarnCallback());
        this.callbacks = callbacks;
    }

    protected void stop() {
        this.keepgoing.set(false);
        try {
            this.queue.put(POISON);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public void setThreadName(ThreadRenamer threadRenamer) {
        threadRenamer.rename("OX-Logger");
    }

    @Override
    public Object call() {
        ArrayList<Loggable> loggables = new ArrayList<Loggable>(16);
        while (this.keepgoing.get()) {
            try {
                loggables.clear();
                Loggable loggable = this.queue.take();
                if (POISON == loggable) {
                    return null;
                }
                loggables.add(loggable);
                this.queue.drainTo(loggables);
                boolean quit = loggables.remove(POISON);
                for (Loggable loggable2 : loggables) {
                    LogCallback callback = this.callbacks.get(loggable2.getLevel());
                    if (null == callback || !callback.isLoggable(loggable2.getLog())) continue;
                    this.invokeCallback(loggable2, callback);
                }
                if (!quit) continue;
                return null;
            }
            catch (Exception e) {
                try {
                    Log logger = LogFactory.getLog(LoggerTask.class);
                    logger.error((Object)"LoggerTask run failed", (Throwable)e);
                }
                catch (Exception exception) {}
            }
        }
        return null;
    }

    private void invokeCallback(Loggable loggable, LogCallback callback) {
        StackTraceElement[] trace;
        String msg;
        Object message = loggable.getMessage();
        if (null == message) {
            msg = "null";
        } else {
            msg = this.toString(message, loggable);
            if (msg.startsWith(PREFIX)) {
                callback.log(msg, loggable.getThrowable(), loggable.getLog());
                return;
            }
            msg = CRLF.matcher(msg).replaceAll(this.lineSeparator + " ");
        }
        Throwable throwable = loggable.getThrowable();
        if (null != throwable) {
            this.report(throwable);
        }
        if (null == (trace = loggable.getCallerTrace())) {
            callback.log(msg, throwable, loggable.getLog());
            return;
        }
        StringBuilder sb = new StringBuilder(1024);
        this.appendLogLocation(trace, sb);
        sb.append(msg);
        int maxMessageLength = this.maxMessageLength;
        if (maxMessageLength > 0 && sb.length() > maxMessageLength) {
            String delim = this.lineSeparator + " ";
            boolean first = true;
            do {
                String substring;
                int pos;
                if ((pos = sb.lastIndexOf(delim, maxMessageLength)) > 0) {
                    substring = sb.substring(0, pos);
                    if (first) {
                        first = false;
                    } else {
                        substring = "..." + delim + substring;
                    }
                    sb.delete(0, pos + delim.length());
                    callback.log(substring + "...", sb.length() <= 0 ? throwable : null, loggable.getLog());
                    continue;
                }
                substring = sb.substring(0, maxMessageLength);
                if (first) {
                    first = false;
                } else {
                    substring = "..." + delim + substring;
                }
                sb.delete(0, maxMessageLength);
                callback.log(substring + "...", sb.length() <= 0 ? throwable : null, loggable.getLog());
            } while (sb.length() > maxMessageLength);
            if (sb.length() > 0) {
                callback.log("..." + delim + sb.toString(), throwable, loggable.getLog());
            }
        } else {
            callback.log(sb.toString(), throwable, loggable.getLog());
        }
    }

    private void report(Throwable throwable) {
        NearRegistryServiceTracker<ReportedThrowableHandler> registry = this.registry;
        if (null == registry) {
            return;
        }
        List handlers = registry.getServiceList();
        if (null != handlers) {
            ReportedThrowable reportedThrowable = new ReportedThrowable(throwable);
            for (ReportedThrowableHandler reportedThrowableHandler : handlers) {
                reportedThrowableHandler.handleReportedThrowable(reportedThrowable);
            }
        }
    }

    private void appendLogLocation(StackTraceElement[] trace, StringBuilder sb) {
        boolean found = false;
        for (int i = 0; !found && i < trace.length; ++i) {
            StackTraceElement ste = trace[i];
            String className = ste.getClassName();
            if (null == className || className.startsWith("com.openexchange.log") || className.startsWith("com.openexchange.exception.Log") || className.indexOf("LoggingLogic", 16) >= 0) continue;
            sb.append(PREFIX).append(className).append('.').append(ste.getMethodName());
            if (ste.isNativeMethod()) {
                sb.append("(Native Method)");
            } else {
                String fileName = ste.getFileName();
                if (null == fileName) {
                    sb.append("(Unknown Source)");
                } else {
                    int lineNumber = ste.getLineNumber();
                    sb.append('(').append(fileName);
                    if (lineNumber >= 0) {
                        sb.append(':').append(lineNumber);
                    }
                    sb.append(')');
                }
            }
            sb.append(this.lineSeparator).append(' ');
            found = true;
        }
    }

    private String toString(Object message, Loggable loggable) {
        try {
            return message.toString();
        }
        catch (Exception e) {
            StringBuilder sb = new StringBuilder(256);
            sb.append("Bad message object.").append(this.lineSeparator);
            StackTraceElement[] trace = loggable.getCallerTrace();
            if (null != trace) {
                this.appendLogLocation(trace, sb);
            }
            throw new IllegalArgumentException(sb.toString(), e);
        }
    }
}

