/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.subscribe.internal;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.generic.FolderUpdaterServiceV2;
import com.openexchange.groupware.generic.TargetFolderDefinition;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.subscribe.internal.FolderUpdaterStrategy;
import java.util.Collection;

public class StrategyFolderUpdaterService<T>
implements FolderUpdaterServiceV2<T> {
    private final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(StrategyFolderUpdaterService.class));
    private final FolderUpdaterStrategy<T> strategy;
    private boolean usesMultipleStrategy = false;

    public StrategyFolderUpdaterService(FolderUpdaterStrategy<T> strategy) {
        this.strategy = strategy;
    }

    public StrategyFolderUpdaterService(FolderUpdaterStrategy<T> strategy, boolean usesMultipleStrategy) {
        this.strategy = strategy;
        this.usesMultipleStrategy = usesMultipleStrategy;
    }

    public boolean handles(FolderObject folder) {
        return this.strategy.handles(folder);
    }

    public void save(Collection<T> data, TargetFolderDefinition target) throws OXException {
        Object session = this.strategy.startSession(target);
        Collection<T> dataInFolder = this.strategy.getData(target, session);
        for (T element : data) {
            try {
                T bestMatch = this.findBestMatch(element, dataInFolder, session);
                if (bestMatch == null) {
                    this.strategy.save(element, session);
                    continue;
                }
                this.strategy.update(bestMatch, element, session);
            }
            catch (OXException x) {
                this.LOG.error((Object)x.getMessage(), (Throwable)x);
            }
        }
        this.strategy.closeSession(session);
    }

    public void save(Collection<T> data, TargetFolderDefinition target, Collection<OXException> errors) throws OXException {
        Object session = this.strategy.startSession(target);
        Collection<T> dataInFolder = this.strategy.getData(target, session);
        for (T element : data) {
            try {
                T bestMatch = this.findBestMatch(element, dataInFolder, session);
                if (bestMatch == null) {
                    this.strategy.save(element, session);
                    continue;
                }
                this.strategy.update(bestMatch, element, session);
            }
            catch (OXException x) {
                if (null == errors) {
                    this.LOG.error((Object)x.getMessage(), (Throwable)x);
                    continue;
                }
                errors.add(x);
            }
        }
        this.strategy.closeSession(session);
    }

    private T findBestMatch(T element, Collection<T> dataInFolder, Object session) throws OXException {
        int maxScore = -1;
        T maxElement = null;
        for (T elementInFolder : dataInFolder) {
            int currentScore = this.strategy.calculateSimilarityScore(elementInFolder, element, session);
            if (currentScore <= maxScore) continue;
            maxElement = elementInFolder;
            maxScore = currentScore;
        }
        if (maxScore > this.strategy.getThreshold(session)) {
            return maxElement;
        }
        return null;
    }

    public boolean usesMultipleStrategy() {
        return this.usesMultipleStrategy;
    }
}

