/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.xml;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.CalendarObject;
import com.openexchange.groupware.container.Participant;
import com.openexchange.groupware.container.UserParticipant;
import com.openexchange.tools.iterator.SearchIteratorException;
import com.openexchange.webdav.WebdavExceptionCode;
import com.openexchange.webdav.xml.CommonWriter;
import com.openexchange.webdav.xml.XmlServlet;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import org.jdom2.Content;
import org.jdom2.Element;

public abstract class CalendarWriter
extends CommonWriter {
    private static final String CONFIRM_ATTRIBUTE = "confirm";

    protected CalendarWriter() {
    }

    protected void writeCalendarElements(CalendarObject calendarobject, Element e_prop) throws OXException, SearchIteratorException, UnsupportedEncodingException {
        CalendarWriter.addElement("title", calendarobject.getTitle(), e_prop);
        CalendarWriter.addElement("note", calendarobject.getNote(), e_prop);
        this.addRecurrenceElements(calendarobject, e_prop);
        this.addElementParticipants(calendarobject, e_prop);
        this.writeCommonElements(calendarobject, e_prop);
    }

    public void addRecurrenceElements(CalendarObject calendarobject, Element e_prop) throws OXException {
        if (calendarobject.containsRecurrenceID()) {
            CalendarWriter.addElement("recurrence_id", calendarobject.getRecurrenceID(), e_prop);
        }
        if (calendarobject.containsRecurrencePosition()) {
            CalendarWriter.addElement("recurrence_position", calendarobject.getRecurrencePosition(), e_prop);
        }
        int recurrenceType = calendarobject.getRecurrenceType();
        switch (recurrenceType) {
            case 0: {
                break;
            }
            case 1: {
                CalendarWriter.addElement("recurrence_type", "daily", e_prop);
                break;
            }
            case 2: {
                CalendarWriter.addElement("recurrence_type", "weekly", e_prop);
                CalendarWriter.addElement("days", calendarobject.getDays(), e_prop);
                break;
            }
            case 3: {
                CalendarWriter.addElement("recurrence_type", "monthly", e_prop);
                CalendarWriter.addElement("day_in_month", calendarobject.getDayInMonth(), e_prop);
                if (!calendarobject.containsDays()) break;
                CalendarWriter.addElement("days", calendarobject.getDays(), e_prop);
                break;
            }
            case 4: {
                CalendarWriter.addElement("recurrence_type", "yearly", e_prop);
                CalendarWriter.addElement("day_in_month", calendarobject.getDayInMonth(), e_prop);
                if (calendarobject.containsDays()) {
                    CalendarWriter.addElement("days", calendarobject.getDays(), e_prop);
                }
                CalendarWriter.addElement("month", calendarobject.getMonth(), e_prop);
                break;
            }
            default: {
                throw WebdavExceptionCode.IO_ERROR.create("invalid recurrence type: " + recurrenceType);
            }
        }
        if (calendarobject.containsInterval()) {
            CalendarWriter.addElement("interval", calendarobject.getInterval(), e_prop);
        }
        if (calendarobject.containsUntil()) {
            CalendarWriter.addElement("until", calendarobject.getUntil(), e_prop);
        }
        if (calendarobject.containsOccurrence()) {
            CalendarWriter.addElement("occurrences", calendarobject.getOccurrence(), e_prop);
        }
    }

    public void addElementParticipants(CalendarObject calendarobject, Element e_prop) throws OXException {
        boolean hasParticipants = false;
        Element e_participants = new Element("participants", XmlServlet.NS);
        Participant[] participant = calendarobject.getParticipants();
        Object[] userparticipant = calendarobject.getUsers();
        boolean hasUserParticipants = false;
        if (participant != null) {
            hasParticipants = true;
            if (userparticipant != null) {
                Arrays.sort(userparticipant);
                hasUserParticipants = true;
            }
            for (int a = 0; a < participant.length; ++a) {
                Element eParticipant;
                int type = participant[a].getType();
                boolean external = false;
                switch (type) {
                    case 1: {
                        eParticipant = new Element("user", XmlServlet.NS);
                        eParticipant.addContent(Integer.toString(participant[a].getIdentifier()));
                        if (hasUserParticipants) {
                            int userPos = Arrays.binarySearch(userparticipant, participant[a]);
                            if (userPos < 0) break;
                            if (((UserParticipant)userparticipant[userPos]).getConfirm() == 0) {
                                eParticipant.setAttribute(CONFIRM_ATTRIBUTE, "none", XmlServlet.NS);
                                break;
                            }
                            if (((UserParticipant)userparticipant[userPos]).getConfirm() == 1) {
                                eParticipant.setAttribute(CONFIRM_ATTRIBUTE, "accept", XmlServlet.NS);
                                break;
                            }
                            if (((UserParticipant)userparticipant[userPos]).getConfirm() == 2) {
                                eParticipant.setAttribute(CONFIRM_ATTRIBUTE, "decline", XmlServlet.NS);
                                break;
                            }
                            if (((UserParticipant)userparticipant[userPos]).getConfirm() == 3) {
                                eParticipant.setAttribute(CONFIRM_ATTRIBUTE, "tentative", XmlServlet.NS);
                                break;
                            }
                            throw WebdavExceptionCode.IO_ERROR.create("invalid value in confirm: " + ((UserParticipant)userparticipant[a]).getConfirm());
                        }
                        eParticipant.setAttribute(CONFIRM_ATTRIBUTE, "none", XmlServlet.NS);
                        break;
                    }
                    case 2: {
                        eParticipant = new Element("group", XmlServlet.NS);
                        eParticipant.addContent(Integer.toString(participant[a].getIdentifier()));
                        break;
                    }
                    case 3: {
                        eParticipant = new Element("resource", XmlServlet.NS);
                        eParticipant.addContent(Integer.toString(participant[a].getIdentifier()));
                        break;
                    }
                    case 5: {
                        eParticipant = new Element("user", XmlServlet.NS);
                        eParticipant.addContent(Integer.toString(participant[a].getIdentifier()));
                        if (participant[a].getDisplayName() != null) {
                            eParticipant.setAttribute("displayname", participant[a].getDisplayName(), XmlServlet.NS);
                        } else {
                            eParticipant.setAttribute("displayname", "", XmlServlet.NS);
                        }
                        if (participant[a].getEmailAddress() != null) {
                            eParticipant.setAttribute("mail", participant[a].getEmailAddress(), XmlServlet.NS);
                        } else {
                            eParticipant.setAttribute("mail", "", XmlServlet.NS);
                        }
                        external = true;
                        break;
                    }
                    case 6: {
                        eParticipant = new Element("group", XmlServlet.NS);
                        eParticipant.addContent(Integer.toString(participant[a].getIdentifier()));
                        if (participant[a].getDisplayName() != null) {
                            eParticipant.setAttribute("displayname", participant[a].getDisplayName(), XmlServlet.NS);
                        } else {
                            eParticipant.setAttribute("displayname", "", XmlServlet.NS);
                        }
                        if (participant[a].getEmailAddress() != null) {
                            eParticipant.setAttribute("mail", participant[a].getEmailAddress(), XmlServlet.NS);
                        } else {
                            eParticipant.setAttribute("mail", "", XmlServlet.NS);
                        }
                        external = true;
                        break;
                    }
                    default: {
                        throw WebdavExceptionCode.IO_ERROR.create("invalid type in participant: " + type);
                    }
                }
                eParticipant.setAttribute("external", String.valueOf(external), XmlServlet.NS);
                e_participants.addContent((Content)eParticipant);
            }
        }
        if (hasParticipants) {
            e_prop.addContent((Content)e_participants);
        }
    }
}

