/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.protocol;

import com.openexchange.exception.Category;
import com.openexchange.exception.LogLevel;
import com.openexchange.exception.OXException;
import com.openexchange.exception.OXExceptionCode;
import com.openexchange.exception.OXExceptionFactory;
import com.openexchange.groupware.EnumComponent;
import com.openexchange.webdav.protocol.WebdavPath;
import com.openexchange.webdav.protocol.WebdavStatus;

public class WebdavProtocolException
extends OXException
implements WebdavStatus<Object> {
    private static final long serialVersionUID = 617401197355575125L;
    private final int status;
    private final transient WebdavPath url;

    public static WebdavProtocolException generalError(Throwable t, WebdavPath url, int status) {
        return Code.GENERAL_ERROR.create(url, status, t, new Object[0]);
    }

    public static WebdavProtocolException generalError(WebdavPath url, int status) {
        return Code.GENERAL_ERROR.create(url, status);
    }

    protected WebdavProtocolException(int status, WebdavPath url, int code, String displayMessage, Throwable cause, Object ... displayArgs) {
        super(code, displayMessage, cause, displayArgs);
        this.status = status;
        this.url = url;
    }

    public WebdavProtocolException(WebdavPath url, int status, OXException e) {
        super(e);
        this.status = status;
        this.url = url;
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    @Override
    public WebdavPath getUrl() {
        return this.url;
    }

    @Override
    public Object getAdditional() {
        return null;
    }

    public String toString() {
        String msg = super.toString();
        return new StringBuilder(msg.length() + 64).append(msg).append(' ').append(this.getUrl()).append(' ').append(this.getStatus()).toString();
    }

    public static enum Code implements OXExceptionCode
    {
        GENERAL_ERROR("A WebDAV error occurred.", CATEGORY_ERROR, 1000),
        FOLDER_NOT_FOUND("The folder %s doesn't exist.", CATEGORY_ERROR, 1001),
        DIRECTORY_ALREADY_EXISTS("The directory already exists.", CATEGORY_ERROR, 1002),
        NO_WRITE_PERMISSION("No write permission.", CATEGORY_PERMISSION_DENIED, 1003),
        FILE_ALREADY_EXISTS("File \"%1$s\" already exists.", CATEGORY_ERROR, 1004),
        NO_BODIES_ALLOWED("Collections must not have bodies.", CATEGORY_ERROR, 1005),
        FILE_NOT_FOUND("File \"%1$s\" does not exist.", CATEGORY_ERROR, 1006),
        FILE_IS_DIRECTORY("\"%1$s\" is a directory.", CATEGORY_ERROR, 1007);

        private final String message;
        private final int detailNumber;
        private final Category category;

        private Code(String message, Category category, int detailNumber) {
            this.message = message;
            this.detailNumber = detailNumber;
            this.category = category;
        }

        public String getPrefix() {
            return EnumComponent.WEBDAV.getAbbreviation();
        }

        public Category getCategory() {
            return this.category;
        }

        public int getNumber() {
            return this.detailNumber;
        }

        public String getMessage() {
            return this.message;
        }

        public boolean equals(OXException e) {
            return OXExceptionFactory.getInstance().equals((OXExceptionCode)this, e);
        }

        public WebdavProtocolException create(WebdavPath url, int status) {
            return this.create(url, status, new Object[0]);
        }

        public WebdavProtocolException create(WebdavPath url, int status, Object ... args) {
            return this.create(url, status, null, args);
        }

        public WebdavProtocolException create(WebdavPath url, int status, Throwable cause, Object ... args) {
            WebdavProtocolException ret;
            Category category = this.getCategory();
            if (category.getLogLevel().implies(LogLevel.DEBUG)) {
                ret = new WebdavProtocolException(status, url, this.getNumber(), this.getMessage(), cause, args);
            } else {
                ret = new WebdavProtocolException(status, url, this.getNumber(), Category.EnumType.TRY_AGAIN.equals((Object)category.getType()) ? "A temporary error occurred inside the server which prevented it from fulfilling the request. Please try again later." : "An error occurred inside the server which prevented it from fulfilling the request.", cause, new Object[0]);
                ret.setLogMessage(this.getMessage(), args);
            }
            ret.addCategory(category);
            ret.setPrefix(this.getPrefix());
            return ret;
        }
    }
}

