/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav;

import com.openexchange.contact.ContactService;
import com.openexchange.exception.Category;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.groupware.userconfiguration.UserConfiguration;
import com.openexchange.groupware.userconfiguration.UserConfigurationStorage;
import com.openexchange.log.LogFactory;
import com.openexchange.login.Interface;
import com.openexchange.monitoring.MonitoringInfo;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.webdav.LastModifiedCache;
import com.openexchange.webdav.PendingInvocations;
import com.openexchange.webdav.QueuedAction;
import com.openexchange.webdav.WebdavExceptionCode;
import com.openexchange.webdav.xml.ContactParser;
import com.openexchange.webdav.xml.ContactWriter;
import com.openexchange.webdav.xml.XmlServlet;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.jdom2.output.XMLOutputter;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public final class contacts
extends XmlServlet<ContactService> {
    private static final long serialVersionUID = -3731372041610025543L;
    private static final transient Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(contacts.class));

    @Override
    protected Interface getInterface() {
        return Interface.WEBDAV_XML;
    }

    @Override
    protected boolean isServletDisabled() {
        return true;
    }

    @Override
    protected void parsePropChilds(HttpServletRequest req, HttpServletResponse resp, XmlPullParser parser, PendingInvocations<ContactService> pendingInvocations) throws XmlPullParserException, IOException, OXException {
        Session session = contacts.getSession(req);
        if (this.isTag(parser, "prop", "DAV:")) {
            parser.nextTag();
            Contact contactobject = new Contact();
            ContactParser contactparser = new ContactParser(session);
            contactparser.parse(parser, contactobject);
            int method = contactparser.getMethod();
            Date lastModified = contactobject.getLastModified();
            int inFolder = contactparser.getFolder();
            switch (method) {
                case 1: {
                    if (contactobject.containsObjectID()) {
                        pendingInvocations.add(new QueuedContact(contactobject, contactparser.getClientID(), method, lastModified, inFolder, session));
                        break;
                    }
                    contactobject.setParentFolderID(inFolder);
                    if (contactobject.containsImage1() && contactobject.getImage1() == null) {
                        contactobject.removeImage1();
                    }
                    pendingInvocations.add(new QueuedContact(contactobject, contactparser.getClientID(), method, lastModified, inFolder, session));
                    break;
                }
                case 2: {
                    pendingInvocations.add(new QueuedContact(contactobject, contactparser.getClientID(), method, lastModified, inFolder, session));
                    break;
                }
                default: {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("invalid method: " + method));
                        break;
                    } else {
                        break;
                    }
                }
            }
        } else {
            parser.next();
        }
    }

    @Override
    protected void performActions(OutputStream os, Session session, PendingInvocations<ContactService> pendingInvocations) throws IOException {
        ContactService contactService = ServerServiceRegistry.getInstance().getService(ContactService.class);
        while (!pendingInvocations.isEmpty()) {
            QueuedContact qcon = (QueuedContact)pendingInvocations.poll();
            if (null == qcon) continue;
            qcon.setLastModifiedCache(pendingInvocations.getLastModifiedCache());
            qcon.actionPerformed(contactService, os, session.getUserId());
        }
    }

    @Override
    protected void startWriter(Session sessionObj, Context ctx, int objectId, int folderId, OutputStream os) throws Exception {
        User userObj = UserStorage.getStorageUser(sessionObj.getUserId(), ctx);
        ContactWriter contactwriter = new ContactWriter(userObj, ctx, sessionObj);
        contactwriter.startWriter(objectId, folderId, os);
    }

    @Override
    protected void startWriter(Session sessionObj, Context ctx, int folderId, boolean bModified, boolean bDelete, Date lastsync, OutputStream os) throws Exception {
        this.startWriter(sessionObj, ctx, folderId, bModified, bDelete, false, lastsync, os);
    }

    @Override
    protected void startWriter(Session sessionObj, Context ctx, int folderId, boolean bModified, boolean bDelete, boolean bList, Date lastsync, OutputStream os) throws Exception {
        User userObj = UserStorage.getStorageUser(sessionObj.getUserId(), ctx);
        ContactWriter contactwriter = new ContactWriter(userObj, ctx, sessionObj);
        contactwriter.startWriter(bModified, bDelete, bList, folderId, lastsync, os);
    }

    @Override
    protected boolean hasModulePermission(Session sessionObj, Context ctx) {
        UserConfiguration uc = UserConfigurationStorage.getInstance().getUserConfigurationSafe(sessionObj.getUserId(), ctx);
        return uc.hasWebDAVXML() && uc.hasContact();
    }

    @Override
    protected void decrementRequests() {
        MonitoringInfo.decrementNumberOfConnections((int)2);
    }

    @Override
    protected void incrementRequests() {
        MonitoringInfo.incrementNumberOfConnections((int)2);
    }

    private final class QueuedContact
    implements QueuedAction<ContactService> {
        private final Contact contactObject;
        private final String clientId;
        private final int action;
        private final Date lastModified;
        private final int inFolder;
        private LastModifiedCache lastModifiedCache;
        private final Session session;

        public QueuedContact(Contact contactObject, String clientId, int action, Date lastModified, int inFolder, Session session) {
            this.contactObject = contactObject;
            this.clientId = clientId;
            this.action = action;
            this.lastModified = lastModified;
            this.inFolder = inFolder;
            this.lastModifiedCache = new LastModifiedCache();
            this.session = session;
        }

        @Override
        public void actionPerformed(ContactService contactService, OutputStream os, int user) throws IOException {
            XMLOutputter xo = new XMLOutputter();
            if (this.contactObject.getLastModified() == null) {
                this.contactObject.setLastModified(this.lastModified);
            }
            try {
                switch (this.action) {
                    case 1: {
                        if (this.contactObject.containsObjectID()) {
                            if (this.lastModified == null) {
                                throw WebdavExceptionCode.MISSING_FIELD.create("last_modified");
                            }
                            Date currentLastModified = this.lastModifiedCache.getLastModified(this.contactObject.getObjectID(), this.lastModified);
                            this.lastModifiedCache.update(this.contactObject.getObjectID(), 0, this.lastModified);
                            contactService.updateContact(this.session, Integer.toString(this.inFolder), Integer.toString(this.contactObject.getObjectID()), this.contactObject, currentLastModified);
                            this.lastModifiedCache.update(this.contactObject.getObjectID(), 0, this.contactObject.getLastModified());
                            break;
                        }
                        contactService.createContact(this.session, Integer.toString(this.inFolder), this.contactObject);
                        this.lastModifiedCache.update(this.contactObject.getObjectID(), 0, this.contactObject.getLastModified());
                        break;
                    }
                    case 2: {
                        if (this.lastModified == null) {
                            throw WebdavExceptionCode.MISSING_FIELD.create("last_modified");
                        }
                        contactService.deleteContact(this.session, Integer.toString(this.inFolder), Integer.toString(this.contactObject.getObjectID()), this.contactObject.getLastModified());
                        break;
                    }
                    default: {
                        throw WebdavExceptionCode.INVALID_ACTION.create(this.action);
                    }
                }
                contacts.this.writeResponse(this.contactObject, 200, "[1200] OK", this.clientId, os, xo);
            }
            catch (OXException exc) {
                exc.log(LOG);
                if (exc.isMandatory()) {
                    LOG.debug((Object)"parsePropChilds", (Throwable)exc);
                    contacts.this.writeResponse(this.contactObject, 409, contacts.this.getErrorMessage(exc, "[%s] Missing field"), this.clientId, os, xo);
                } else if (exc.isNoPermission()) {
                    LOG.debug((Object)"parsePropChilds", (Throwable)exc);
                    contacts.this.writeResponse(this.contactObject, 403, contacts.this.getErrorMessage(exc, "[%s] No permission"), this.clientId, os, xo);
                } else if (exc.isConflict()) {
                    LOG.debug((Object)"parsePropChilds", (Throwable)exc);
                    contacts.this.writeResponse(this.contactObject, 409, "[1000] This object was modified on the server", this.clientId, os, xo);
                } else if (exc.isNotFound()) {
                    LOG.debug((Object)"parsePropChilds", (Throwable)exc);
                    contacts.this.writeResponse(this.contactObject, 404, "[1001] Object not found", this.clientId, os, xo);
                } else if (exc.getCategory() == Category.CATEGORY_TRUNCATED) {
                    LOG.debug((Object)"parsePropChilds", (Throwable)exc);
                    contacts.this.writeResponse(this.contactObject, 409, contacts.this.getErrorMessage(exc, "[%s] invalid user input"), this.clientId, os, xo);
                } else {
                    LOG.error((Object)"parsePropChilds", (Throwable)exc);
                    contacts.this.writeResponse(this.contactObject, 500, contacts.this.getErrorMessage(exc, "[%s] Server Error - ") + exc.toString(), this.clientId, os, xo);
                }
            }
            catch (Exception exc) {
                LOG.error((Object)"parsePropChilds", (Throwable)exc);
                contacts.this.writeResponse(this.contactObject, 500, contacts.this.getErrorMessage("[%s] Server Error - ", "undefinied error") + exc.toString(), this.clientId, os, xo);
            }
        }

        public void setLastModifiedCache(LastModifiedCache lastModifiedCache) {
            this.lastModifiedCache = lastModifiedCache;
        }
    }
}

