/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.userconfiguration.UserConfiguration;
import com.openexchange.groupware.userconfiguration.UserConfigurationStorage;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.login.Interface;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.tools.session.ServerSessionAdapter;
import com.openexchange.tools.webdav.OXServlet;
import com.openexchange.webdav.InfostorePerformer;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class Infostore
extends OXServlet {
    private static final long serialVersionUID = -2064098724675986123L;
    private static final transient org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(Infostore.class));

    @Override
    protected Interface getInterface() {
        return Interface.WEBDAV_INFOSTORE;
    }

    @Override
    protected void doCopy(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doIt(req, resp, InfostorePerformer.Action.COPY);
    }

    @Override
    protected void doLock(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doIt(req, resp, InfostorePerformer.Action.LOCK);
    }

    @Override
    protected void doMkCol(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doIt(req, resp, InfostorePerformer.Action.MKCOL);
    }

    @Override
    protected void doMove(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doIt(req, resp, InfostorePerformer.Action.MOVE);
    }

    @Override
    protected void doOptions(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doIt(req, resp, InfostorePerformer.Action.OPTIONS);
    }

    @Override
    protected void doPropFind(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doIt(req, resp, InfostorePerformer.Action.PROPFIND);
    }

    @Override
    protected void doPropPatch(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doIt(req, resp, InfostorePerformer.Action.PROPPATCH);
    }

    @Override
    protected void doUnLock(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doIt(req, resp, InfostorePerformer.Action.UNLOCK);
    }

    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doIt(req, resp, InfostorePerformer.Action.DELETE);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doIt(req, resp, InfostorePerformer.Action.GET);
    }

    protected void doHead(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doIt(req, resp, InfostorePerformer.Action.HEAD);
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doIt(req, resp, InfostorePerformer.Action.PUT);
    }

    protected void doTrace(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doIt(req, resp, InfostorePerformer.Action.TRACE);
    }

    private void doIt(HttpServletRequest req, HttpServletResponse resp, InfostorePerformer.Action action) throws ServletException, IOException {
        ServerSession session;
        try {
            session = ServerSessionAdapter.valueOf(Infostore.getSession(req));
        }
        catch (OXException exc) {
            resp.setStatus(500);
            return;
        }
        UserConfiguration uc = UserConfigurationStorage.getInstance().getUserConfigurationSafe(session.getUserId(), session.getContext());
        if (uc.hasWebDAV() && uc.hasInfostore()) {
            InfostorePerformer.getInstance().doIt(req, resp, action, session);
        } else {
            resp.setStatus(412);
        }
    }
}

