/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.webdav;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.openexchange.authentication.LoginExceptionCodes;
import com.openexchange.exception.OXException;
import com.openexchange.java.StringAllocator;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.login.LoginRequest;
import com.openexchange.login.internal.LoginPerformer;
import com.openexchange.session.Session;
import com.openexchange.tools.encoding.Base64;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;

public class WebDAVSessionStore {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(WebDAVSessionStore.class));
    private static final WebDAVSessionStore instance = new WebDAVSessionStore();
    private final Cache<String, Session> webdavSessions = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).expireAfterWrite(1L, TimeUnit.HOURS).removalListener((RemovalListener)new RemovalListener<String, Session>(){

        public void onRemoval(RemovalNotification<String, Session> notification) {
            WebDAVSessionStore.logout((Session)notification.getValue());
        }
    }).build();

    public static WebDAVSessionStore getInstance() {
        return instance;
    }

    private WebDAVSessionStore() {
    }

    public Session getSession(final LoginRequest loginRequest) throws OXException {
        String key = WebDAVSessionStore.getKey(loginRequest);
        try {
            return (Session)this.webdavSessions.get((Object)key, (Callable)new Callable<Session>(){

                @Override
                public Session call() throws Exception {
                    return WebDAVSessionStore.login(loginRequest);
                }
            });
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (null != cause && OXException.class.isInstance(e.getCause())) {
                throw (OXException)cause;
            }
            throw LoginExceptionCodes.UNKNOWN.create((Throwable)e, new Object[]{e.getMessage()});
        }
    }

    private static Session login(LoginRequest loginRequest) throws OXException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("WebDAV Login: " + loginRequest.getLogin() + "..."));
        }
        Session session = LoginPerformer.getInstance().doLogin(loginRequest).getSession();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Added WebDAV session " + session));
        }
        return session;
    }

    private static void logout(Session session) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("WebDAV Logout: " + session + "..."));
        }
        try {
            Session removedSession = LoginPerformer.getInstance().doLogout(session.getSessionID());
            if (LOG.isDebugEnabled()) {
                if (null != removedSession) {
                    LOG.debug((Object)("Removed WebDAV session " + removedSession));
                } else {
                    LOG.debug((Object)("WebDAV session " + session + " not removed."));
                }
            }
        }
        catch (OXException e) {
            LOG.warn((Object)"Error removing WebDAV session", (Throwable)e);
        }
    }

    private static String getKey(LoginRequest loginRequest) {
        int clientHash = ((Object)((Object)loginRequest.getInterface()) + loginRequest.getUserAgent() + loginRequest.getClientIP()).hashCode();
        return Base64.encode(new StringAllocator().append(loginRequest.getLogin()).append(loginRequest.getPassword()).append(clientHash).toString());
    }
}

