/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.versit.valuedefinitions.rfc2445;

import com.openexchange.java.Charsets;
import com.openexchange.tools.encoding.Base64;
import com.openexchange.tools.versit.Encoding;
import com.openexchange.tools.versit.FoldingWriter;
import com.openexchange.tools.versit.Parameter;
import com.openexchange.tools.versit.Property;
import com.openexchange.tools.versit.Scanner;
import com.openexchange.tools.versit.StringScanner;
import com.openexchange.tools.versit.ValueDefinition;
import com.openexchange.tools.versit.VersitException;
import com.openexchange.tools.versit.encodings.BASE64Encoding;
import java.io.IOException;

public class BinaryValueDefinition
extends ValueDefinition {
    public BinaryValueDefinition(String[] encodingNames, Encoding[] encodings) {
        super(encodingNames, encodings);
    }

    @Override
    public Object createValue(StringScanner s, Property property) throws IOException {
        return s.getRest().getBytes(Charsets.ISO_8859_1);
    }

    @Override
    public String writeValue(Object value) {
        return new String((byte[])value, Charsets.ISO_8859_1);
    }

    @Override
    public void write(FoldingWriter fw, Property property) throws IOException {
        String value = null;
        Parameter encodingParam = property.getParameter("ENCODING");
        if (encodingParam != null) {
            String enc_name = encodingParam.getValue(0).getText();
            Encoding encoding = this.getEncoding(enc_name);
            if (encoding == null) {
                throw new IOException("Unknown encoding: " + enc_name);
            }
            Object propValue = property.getValue();
            value = null != propValue && BASE64Encoding.class.equals(encoding.getClass()) && byte[].class.equals(propValue.getClass()) ? Base64.encode((byte[])propValue) : this.writeValue(property.getValue());
        } else {
            value = this.writeValue(property.getValue());
        }
        fw.writeln(value);
    }

    @Override
    public Object parse(Scanner s, Property property) throws IOException {
        StringBuilder sb = new StringBuilder();
        while ((s.peek >= 32 || s.peek == 9) && s.peek != 127) {
            sb.append((char)s.read());
        }
        String text = sb.toString();
        Parameter encodingParam = property.getParameter("ENCODING");
        if (encodingParam != null) {
            String EncName = encodingParam.getValue(0).getText();
            Encoding encoding = this.getEncoding(EncName);
            if (encoding == null) {
                throw new VersitException(s, "Unknown encoding: " + EncName);
            }
            if (BASE64Encoding.class.equals(encoding.getClass())) {
                return Base64.decode(text);
            }
            return this.createValue(new StringScanner(s, encoding.decode(text)), property);
        }
        return this.createValue(new StringScanner(s, text), property);
    }
}

