/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.servlet;

import com.javacodegeeks.concurrent.ConcurrentLinkedHashMap;
import com.javacodegeeks.concurrent.EvictionPolicy;
import com.javacodegeeks.concurrent.LRUPolicy;
import com.openexchange.ajax.requesthandler.DefaultDispatcherPrefixService;
import com.openexchange.config.ConfigurationService;
import com.openexchange.java.StringAllocator;
import com.openexchange.java.Strings;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.timer.ScheduledTimerTask;
import com.openexchange.timer.TimerService;
import com.openexchange.tools.servlet.CountingHttpServletRequest;
import com.openexchange.tools.servlet.Rate;
import com.openexchange.tools.servlet.http.Cookies;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;

public final class RateLimiter {
    private static final Log LOG = com.openexchange.log.Log.loggerFor(RateLimiter.class);
    private static final KeyPartProvider HTTP_SESSION_KEY_PART_PROVIDER = new KeyPartProvider(){

        @Override
        public String getValue(HttpServletRequest servletRequest) {
            Map<String, Cookie> cookies = Cookies.cookieMapFor(servletRequest);
            if (null == cookies) {
                return null;
            }
            Cookie cookie = cookies.get("JSESSIONID");
            return null == cookie ? null : cookie.getValue();
        }
    };
    private static volatile List<KeyPartProvider> keyPartProviders;
    private static volatile Boolean considerRemotePort;
    private static volatile ScheduledTimerTask timerTask;
    private static volatile ConcurrentMap<Key, Rate> bucketMap;
    private static volatile Integer maxRate;
    private static volatile Integer maxRateTimeWindow;
    private static volatile Boolean omitLocals;
    private static final Set<String> LOCALS;
    private static volatile List<UserAgentChecker> userAgentCheckers;
    private static volatile List<String> modules;

    private RateLimiter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static List<KeyPartProvider> keyPartProviders() {
        List<KeyPartProvider> tmp = keyPartProviders;
        if (null != tmp) return tmp;
        Class<CountingHttpServletRequest> clazz = CountingHttpServletRequest.class;
        synchronized (CountingHttpServletRequest.class) {
            tmp = keyPartProviders;
            if (null != tmp) return tmp;
            ConfigurationService service = ServerServiceRegistry.getInstance().getService(ConfigurationService.class);
            if (null == service) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return Collections.emptyList();
            }
            String sProviders = service.getProperty("com.openexchange.servlet.maxRateKeyPartProviders");
            if (RateLimiter.isEmpty(sProviders)) {
                tmp = Collections.emptyList();
            } else {
                LinkedList<KeyPartProvider> list = new LinkedList<KeyPartProvider>();
                for (String sProvider : Strings.splitByComma((String)sProviders)) {
                    String s = RateLimiter.toLowerCase(sProvider);
                    if ("http-session".equals(s)) {
                        list.add(HTTP_SESSION_KEY_PART_PROVIDER);
                        continue;
                    }
                    if (s.startsWith("cookie-")) {
                        list.add(new CookieKeyPartProvider(s.substring(7)));
                        continue;
                    }
                    if (s.startsWith("header-")) {
                        list.add(new HeaderKeyPartProvider(s.substring(7)));
                        continue;
                    }
                    if (!s.startsWith("parameter-")) continue;
                    list.add(new ParameterKeyPartProvider(s.substring(10)));
                }
                tmp = Collections.unmodifiableList(list);
            }
            keyPartProviders = tmp;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return tmp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static boolean considerRemotePort() {
        Boolean tmp = considerRemotePort;
        if (null != tmp) return tmp;
        Class<CountingHttpServletRequest> clazz = CountingHttpServletRequest.class;
        synchronized (CountingHttpServletRequest.class) {
            tmp = considerRemotePort;
            if (null != tmp) return tmp;
            ConfigurationService service = ServerServiceRegistry.getInstance().getService(ConfigurationService.class);
            if (null == service) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return false;
            }
            considerRemotePort = tmp = Boolean.valueOf(service.getProperty("com.openexchange.servlet.maxRateConsiderRemotePort", "false"));
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return tmp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static ConcurrentMap<Key, Rate> bucketMap() {
        ConcurrentLinkedHashMap tmp = bucketMap;
        if (null != tmp) return tmp;
        Class<RateLimiter> clazz = RateLimiter.class;
        synchronized (RateLimiter.class) {
            ConcurrentLinkedHashMap tmp2;
            tmp = bucketMap;
            if (null != tmp) return tmp;
            ConfigurationService service = ServerServiceRegistry.getInstance().getService(ConfigurationService.class);
            TimerService timerService = ServerServiceRegistry.getInstance().getService(TimerService.class);
            if (null == service || null == timerService) {
                LOG.info((Object)(RateLimiter.class.getSimpleName() + " not yet fully initialized; awaiting " + (null == service ? ConfigurationService.class.getSimpleName() : "") + " " + (null == timerService ? TimerService.class.getSimpleName() : "")));
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return null;
            }
            int maxCapacity = service.getIntProperty("com.openexchange.servlet.maxActiveSessions", 250000);
            bucketMap = tmp = (tmp2 = new ConcurrentLinkedHashMap(256, 0.75f, 16, maxCapacity, (EvictionPolicy)new LRUPolicy()));
            int delay = 300000;
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    try {
                        Map.Entry entry;
                        long mark = System.currentTimeMillis() - 600000L;
                        Iterator iterator = tmp2.entrySet().iterator();
                        while (iterator.hasNext() && ((Rate)(entry = (Map.Entry)iterator.next()).getValue()).markDeprecatedIfElapsed(mark)) {
                            iterator.remove();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            };
            timerTask = timerService.scheduleWithFixedDelay(r, 300000L, 300000L);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return tmp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int maxRate() {
        Integer tmp = maxRate;
        if (null != tmp) return tmp;
        Class<RateLimiter> clazz = RateLimiter.class;
        synchronized (RateLimiter.class) {
            tmp = maxRate;
            if (null != tmp) return tmp;
            ConfigurationService service = ServerServiceRegistry.getInstance().getService(ConfigurationService.class);
            if (null == service) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return 1500;
            }
            maxRate = tmp = Integer.valueOf(service.getProperty("com.openexchange.servlet.maxRate", "1500"));
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return tmp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int maxRateTimeWindow() {
        Integer tmp = maxRateTimeWindow;
        if (null != tmp) return tmp;
        Class<RateLimiter> clazz = RateLimiter.class;
        synchronized (RateLimiter.class) {
            tmp = maxRateTimeWindow;
            if (null != tmp) return tmp;
            ConfigurationService service = ServerServiceRegistry.getInstance().getService(ConfigurationService.class);
            if (null == service) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return 300000;
            }
            maxRateTimeWindow = tmp = Integer.valueOf(service.getProperty("com.openexchange.servlet.maxRateTimeWindow", "300000"));
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return tmp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean omitLocals() {
        Boolean tmp = omitLocals;
        if (null != tmp) return tmp;
        Class<RateLimiter> clazz = RateLimiter.class;
        synchronized (RateLimiter.class) {
            tmp = omitLocals;
            if (null != tmp) return tmp;
            ConfigurationService service = ServerServiceRegistry.getInstance().getService(ConfigurationService.class);
            if (null == service) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return false;
            }
            omitLocals = tmp = Boolean.valueOf(service.getProperty("com.openexchange.servlet.maxRateOmitLocals", "false"));
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return tmp;
        }
    }

    public static void stop() {
        ScheduledTimerTask t = timerTask;
        if (null != t) {
            t.cancel();
            timerTask = null;
        }
    }

    public static boolean checkRequest(HttpServletRequest servletRequest) {
        Rate.Result res;
        int maxRatePerMinute = RateLimiter.maxRate();
        if (maxRatePerMinute <= 0) {
            return true;
        }
        int maxRateTimeWindow = RateLimiter.maxRateTimeWindow();
        if (maxRatePerMinute <= 0) {
            return true;
        }
        if (RateLimiter.omitLocals() && LOCALS.contains(servletRequest.getServerName())) {
            return true;
        }
        if (RateLimiter.lenientCheckForRequest(servletRequest)) {
            return true;
        }
        ConcurrentMap<Key, Rate> bucketMap = RateLimiter.bucketMap();
        if (null == bucketMap) {
            return true;
        }
        Key key = new Key(servletRequest, servletRequest.getHeader("User-Agent"));
        while (true) {
            Rate newRate;
            Rate rate;
            if (null == (rate = (Rate)bucketMap.get(key)) && null == (rate = bucketMap.putIfAbsent(key, newRate = new Rate(maxRatePerMinute, maxRateTimeWindow, TimeUnit.MILLISECONDS)))) {
                rate = newRate;
            }
            if (Rate.Result.DEPRECATED != (res = rate.consume(System.currentTimeMillis()))) break;
            bucketMap.remove(key, rate);
        }
        return Rate.Result.SUCCESS == res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static List<UserAgentChecker> userAgentCheckers() {
        List<UserAgentChecker> tmp = userAgentCheckers;
        if (null != tmp) return tmp;
        Class<RateLimiter> clazz = RateLimiter.class;
        synchronized (RateLimiter.class) {
            tmp = userAgentCheckers;
            if (null != tmp) return tmp;
            ConfigurationService service = ServerServiceRegistry.getInstance().getService(ConfigurationService.class);
            if (null == service) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return Collections.emptyList();
            }
            String defaultValue = "\"Open-Xchange .NET HTTP Client*\", \"Open-Xchange USM HTTP Client*\", \"Jakarta Commons-HttpClient*\"";
            String sProviders = service.getProperty("com.openexchange.servlet.maxRateLenientClients", "\"Open-Xchange .NET HTTP Client*\", \"Open-Xchange USM HTTP Client*\", \"Jakarta Commons-HttpClient*\"");
            if (RateLimiter.isEmpty(sProviders)) {
                tmp = Collections.emptyList();
            } else {
                LinkedList<UserAgentChecker> list = new LinkedList<UserAgentChecker>();
                LinkedList<String> startsWiths = new LinkedList<String>();
                for (String sChecker : Strings.splitByComma((String)sProviders)) {
                    String s = RateLimiter.unquote(sChecker);
                    if (RateLimiter.isEmpty(s)) continue;
                    if (RateLimiter.isStartsWith(s = s.trim())) {
                        startsWiths.add(s.substring(0, s.length() - 1));
                        continue;
                    }
                    if (s.indexOf(42) >= 0 || s.indexOf(63) >= 0) {
                        list.add(new PatternUserAgentChecker(s));
                        continue;
                    }
                    list.add(new IgnoreCaseUserAgentChecker(s));
                }
                if (!startsWiths.isEmpty()) {
                    list.add(0, new StartsWithUserAgentChecker(startsWiths));
                }
                tmp = list.isEmpty() ? Collections.emptyList() : (1 == list.size() ? Collections.singletonList(list.get(0)) : Collections.unmodifiableList(list));
            }
            userAgentCheckers = tmp;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return tmp;
        }
    }

    private static boolean lenientCheckForUserAgent(String userAgent) {
        if (null != userAgent) {
            for (UserAgentChecker checker : RateLimiter.userAgentCheckers()) {
                if (!checker.isLenient(userAgent)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static List<String> modules() {
        List<String> tmp = modules;
        if (null != tmp) return tmp;
        Class<RateLimiter> clazz = RateLimiter.class;
        synchronized (RateLimiter.class) {
            tmp = modules;
            if (null != tmp) return tmp;
            ConfigurationService service = ServerServiceRegistry.getInstance().getService(ConfigurationService.class);
            if (null == service) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return Arrays.asList("rt", "system");
            }
            String defaultValue = "rt, system";
            String sModules = service.getProperty("com.openexchange.servlet.maxRateLenientModules", "rt, system");
            if (RateLimiter.isEmpty(sModules)) {
                tmp = Collections.emptyList();
            } else {
                LinkedHashSet<String> set = new LinkedHashSet<String>();
                for (String sModule : Strings.splitByComma((String)sModules)) {
                    String s = RateLimiter.unquote(sModule);
                    if (RateLimiter.isEmpty(s)) continue;
                    s = RateLimiter.toLowerCase(s.trim());
                    set.add(s);
                }
                tmp = set.isEmpty() ? Collections.emptyList() : (1 == set.size() ? Collections.singletonList(set.iterator().next()) : Collections.unmodifiableList(new ArrayList(set)));
            }
            modules = tmp;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return tmp;
        }
    }

    private static boolean lenientCheckForRequest(HttpServletRequest servletRequest) {
        String requestURI = RateLimiter.toLowerCase(servletRequest.getRequestURI());
        StringBuilder sb = new StringBuilder(RateLimiter.toLowerCase(DefaultDispatcherPrefixService.getInstance().getPrefix()));
        int reslen = sb.length();
        for (String module : RateLimiter.modules()) {
            sb.setLength(reslen);
            if (!requestURI.startsWith(sb.append(module).toString())) continue;
            return true;
        }
        return RateLimiter.lenientCheckForUserAgent(servletRequest.getHeader("User-Agent"));
    }

    static String wildcardToRegex(String wildcard) {
        StringBuilder s = new StringBuilder(wildcard.length());
        s.append('^');
        int len = wildcard.length();
        for (int i = 0; i < len; ++i) {
            char c = wildcard.charAt(i);
            if (c == '*') {
                s.append(".*");
                continue;
            }
            if (c == '?') {
                s.append('.');
                continue;
            }
            if (c == '(' || c == ')' || c == '[' || c == ']' || c == '$' || c == '^' || c == '.' || c == '{' || c == '}' || c == '|' || c == '\\') {
                s.append('\\');
                s.append(c);
                continue;
            }
            s.append(c);
        }
        s.append('$');
        return s.toString();
    }

    static boolean isEmpty(String string) {
        if (null == string) {
            return true;
        }
        int len = string.length();
        boolean isWhitespace = true;
        for (int i = 0; isWhitespace && i < len; ++i) {
            isWhitespace = Strings.isWhitespace((char)string.charAt(i));
        }
        return isWhitespace;
    }

    static String toLowerCase(CharSequence chars) {
        if (null == chars) {
            return null;
        }
        int length = chars.length();
        StringAllocator builder = new StringAllocator(length);
        for (int i = 0; i < length; ++i) {
            char c = chars.charAt(i);
            builder.append(c >= 'A' && c <= 'Z' ? (char)(c ^ 0x20) : c);
        }
        return builder.toString();
    }

    private static boolean isStartsWith(String s) {
        if (!s.endsWith("*")) {
            return false;
        }
        int mlen = s.length() - 1;
        int pos = s.indexOf("?");
        if (pos >= 0) {
            return false;
        }
        pos = s.indexOf("*");
        return pos < 0 || pos >= mlen;
    }

    private static String unquote(String s) {
        if (!RateLimiter.isEmpty(s) && (s.startsWith("\"") && s.endsWith("\"") || s.startsWith("'") && s.endsWith("'"))) {
            return s.substring(1, s.length() - 1);
        }
        return s;
    }

    static {
        LOCALS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("localhost", "127.0.0.1", "::1")));
    }

    private static final class PatternUserAgentChecker
    implements UserAgentChecker {
        private final Pattern pattern;

        PatternUserAgentChecker(String wildcard) {
            this.pattern = Pattern.compile(RateLimiter.wildcardToRegex(wildcard), 2);
        }

        @Override
        public boolean isLenient(String userAgent) {
            return this.pattern.matcher(userAgent).matches();
        }
    }

    private static final class IgnoreCaseUserAgentChecker
    implements UserAgentChecker {
        private final String userAgent;

        IgnoreCaseUserAgentChecker(String userAgent) {
            this.userAgent = RateLimiter.toLowerCase(userAgent);
        }

        @Override
        public boolean isLenient(String userAgent) {
            return this.userAgent.equals(RateLimiter.toLowerCase(userAgent));
        }
    }

    private static final class StartsWithUserAgentChecker
    implements UserAgentChecker {
        private final String[] prefixes;

        StartsWithUserAgentChecker(List<String> prefixes) {
            int size = prefixes.size();
            String[] newArray = new String[size];
            for (int i = 0; i < size; ++i) {
                newArray[i] = RateLimiter.toLowerCase(prefixes.get(i));
            }
            this.prefixes = newArray;
        }

        @Override
        public boolean isLenient(String userAgent) {
            String lc = RateLimiter.toLowerCase(userAgent);
            for (String prefix : this.prefixes) {
                if (!lc.startsWith(prefix)) continue;
                return true;
            }
            return false;
        }
    }

    private static interface UserAgentChecker {
        public boolean isLenient(String var1);
    }

    private static final class Key {
        final int remotePort;
        final String remoteAddr;
        final String userAgent;
        final List<String> parts;
        private final int hash;

        Key(HttpServletRequest servletRequest, String userAgent) {
            ArrayList<String> parts;
            this.remotePort = RateLimiter.considerRemotePort() ? servletRequest.getRemotePort() : 0;
            this.remoteAddr = servletRequest.getRemoteAddr();
            this.userAgent = userAgent;
            List<KeyPartProvider> keyPartProviders = RateLimiter.keyPartProviders();
            if (null == keyPartProviders || keyPartProviders.isEmpty()) {
                parts = null;
            } else {
                parts = new ArrayList<String>(keyPartProviders.size());
                for (KeyPartProvider keyPartProvider : keyPartProviders) {
                    parts.add(keyPartProvider.getValue(servletRequest));
                }
            }
            this.parts = parts;
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.remoteAddr == null ? 0 : this.remoteAddr.hashCode());
            result = 31 * result + this.remotePort;
            result = 31 * result + (userAgent == null ? 0 : userAgent.hashCode());
            this.hash = result = 31 * result + (parts == null ? 0 : ((Object)parts).hashCode());
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            Key other = (Key)obj;
            if (this.remotePort != other.remotePort) {
                return false;
            }
            if (this.remoteAddr == null ? other.remoteAddr != null : !this.remoteAddr.equals(other.remoteAddr)) {
                return false;
            }
            if (this.userAgent == null ? other.userAgent != null : !this.userAgent.equals(other.userAgent)) {
                return false;
            }
            return !(this.parts == null ? other.parts != null : !((Object)this.parts).equals(other.parts));
        }

        public String toString() {
            StringAllocator builder = new StringAllocator(256);
            builder.append("Key [");
            if (this.remotePort > 0) {
                builder.append("remotePort=").append(this.remotePort).append(", ");
            }
            if (this.remoteAddr != null) {
                builder.append("remoteAddr=").append(this.remoteAddr).append(", ");
            }
            if (this.userAgent != null) {
                builder.append("userAgent=").append(this.userAgent).append(", ");
            }
            if (this.parts != null) {
                builder.append("parts=").append(this.parts).append(", ");
            }
            builder.append("hash=").append(this.hash).append("]");
            return builder.toString();
        }
    }

    private static final class ParameterKeyPartProvider
    implements KeyPartProvider {
        private final String paramName;

        ParameterKeyPartProvider(String paramName) {
            this.paramName = paramName;
        }

        @Override
        public String getValue(HttpServletRequest servletRequest) {
            return servletRequest.getParameter(this.paramName);
        }
    }

    private static final class HeaderKeyPartProvider
    implements KeyPartProvider {
        private final String headerName;

        HeaderKeyPartProvider(String headerName) {
            this.headerName = headerName;
        }

        @Override
        public String getValue(HttpServletRequest servletRequest) {
            return servletRequest.getHeader(this.headerName);
        }
    }

    private static final class CookieKeyPartProvider
    implements KeyPartProvider {
        private final String cookieName;

        CookieKeyPartProvider(String cookieName) {
            this.cookieName = RateLimiter.toLowerCase(cookieName);
        }

        @Override
        public String getValue(HttpServletRequest servletRequest) {
            Map<String, Cookie> cookies = Cookies.cookieMapFor(servletRequest);
            if (null == cookies) {
                return null;
            }
            Cookie cookie = cookies.get(this.cookieName);
            return null == cookie ? null : cookie.getValue();
        }
    }

    private static interface KeyPartProvider {
        public String getValue(HttpServletRequest var1);
    }
}

