/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.servlet;

import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.concurrent.TimeUnit;

public class Rate {
    private final int numberCalls;
    private final long timeInMillis;
    private final Deque<Long> callHistory = new LinkedList<Long>();
    private boolean deprecated = false;

    public Rate(int numberCalls, int timeLength, TimeUnit timeUnit) {
        this.numberCalls = numberCalls;
        this.timeInMillis = timeUnit.toMillis(timeLength);
    }

    private void cleanOld(long now) {
        Long first;
        long threshold = now - this.timeInMillis;
        while ((first = this.callHistory.peekFirst()) != null && first <= threshold) {
            this.callHistory.pollFirst();
        }
    }

    private long callTime(long now) {
        long call;
        long lastStart;
        this.cleanOld(now);
        int size = this.callHistory.size();
        if (size < this.numberCalls) {
            return now;
        }
        long firstPeriodCall = lastStart = this.callHistory.peekLast() - this.timeInMillis;
        int count = 0;
        Iterator<Long> i = this.callHistory.descendingIterator();
        while (i.hasNext() && (call = i.next().longValue()) >= lastStart) {
            ++count;
            firstPeriodCall = call;
        }
        return count < this.numberCalls ? firstPeriodCall + 1L : firstPeriodCall + this.timeInMillis + 1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long lastAccessTime() {
        Deque<Long> deque = this.callHistory;
        synchronized (deque) {
            Long last = this.callHistory.peekLast();
            return null == last ? Long.MIN_VALUE : last;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDeprecated() {
        Deque<Long> deque = this.callHistory;
        synchronized (deque) {
            return this.deprecated;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean markDeprecatedIfElapsed(long threshold) {
        Deque<Long> deque = this.callHistory;
        synchronized (deque) {
            Long last = this.callHistory.peekLast();
            if (null != last && last > threshold) {
                return false;
            }
            this.deprecated = true;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty(long now) {
        Deque<Long> deque = this.callHistory;
        synchronized (deque) {
            this.cleanOld(now);
            return this.callHistory.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result consume(long now) {
        Deque<Long> deque = this.callHistory;
        synchronized (deque) {
            if (this.deprecated) {
                return Result.DEPRECATED;
            }
            long callTime = this.callTime(now);
            this.callHistory.offerLast(callTime);
            return callTime - now <= 0L ? Result.SUCCESS : Result.FAILED;
        }
    }

    public static void main(String[] args) {
        int i;
        Rate rate = new Rate(5, 5, TimeUnit.SECONDS);
        long callTime = System.currentTimeMillis();
        for (i = 0; i < 6; ++i) {
            System.out.println((Object)rate.consume(callTime));
            callTime += 100L;
        }
        System.out.println("-------------------------");
        callTime += 6000L;
        for (i = 0; i < 6; ++i) {
            System.out.println((Object)rate.consume(callTime));
            callTime += 100L;
        }
        System.out.println("-------------------------");
    }

    public static enum Result {
        SUCCESS,
        FAILED,
        DEPRECATED;

    }
}

