/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.oxfolder.treeconsistency;

import com.openexchange.cache.impl.FolderCacheManager;
import com.openexchange.cache.impl.FolderQueryCacheManager;
import com.openexchange.exception.OXException;
import com.openexchange.group.GroupStorage;
import com.openexchange.groupware.calendar.CalendarCache;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.log.LogFactory;
import com.openexchange.server.impl.OCLPermission;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.tools.oxfolder.OXFolderExceptionCode;
import com.openexchange.tools.oxfolder.OXFolderSQL;
import com.openexchange.tools.oxfolder.memory.ConditionTreeMapManagement;
import com.openexchange.tools.oxfolder.treeconsistency.CheckPermission;
import com.openexchange.tools.oxfolder.treeconsistency.ToDoPermission;
import gnu.trove.iterator.TIntObjectIterator;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.osgi.service.event.EventAdmin;

public final class CheckPermissionOnRemove
extends CheckPermission {
    private static final Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(CheckPermissionOnRemove.class));

    public CheckPermissionOnRemove(Session session, Connection writeCon, Context ctx) {
        super(session, writeCon, ctx);
    }

    public void checkPermissionsOnUpdate(int folderId, OCLPermission[] removedPerms, long lastModified) throws OXException {
        try {
            FolderObject folder = this.getFolderFromMaster(folderId);
            TIntObjectHashMap toRemove = new TIntObjectHashMap();
            List<OCLPermission> permissions = folder.getPermissions();
            for (OCLPermission perm : removedPerms) {
                OCLPermission removedPerm = perm;
                if (CheckPermissionOnRemove.containsSystemPermission(permissions, removedPerm.getEntity())) continue;
                int parent = folder.getParentFolderID();
                this.hasVisibleSibling(parent, folderId, parent, removedPerm.getEntity(), removedPerm.isGroupPermission(), (TIntObjectMap<ToDoPermission>)toRemove);
            }
            if (!toRemove.isEmpty()) {
                this.removeSystemPermissions(lastModified, (TIntObjectMap<ToDoPermission>)toRemove);
            }
        }
        catch (SQLException e) {
            throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
        }
    }

    public void checkPermissionsOnDelete(int parent, int deletedId, OCLPermission[] formerPerms, long lastModified) throws OXException {
        try {
            TIntObjectHashMap toRemove = new TIntObjectHashMap();
            for (OCLPermission formerPerm : formerPerms) {
                this.hasVisibleSibling(parent, deletedId, parent, formerPerm.getEntity(), formerPerm.isGroupPermission(), (TIntObjectMap<ToDoPermission>)toRemove);
            }
            if (!toRemove.isEmpty()) {
                this.removeSystemPermissions(lastModified, (TIntObjectMap<ToDoPermission>)toRemove);
            }
        }
        catch (SQLException e) {
            throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
        }
    }

    private void hasVisibleSibling(int parent, int exclude, int origin, int entity, boolean isGroup, TIntObjectMap<ToDoPermission> toRemove) throws OXException, OXException, SQLException {
        if (parent < 20) {
            return;
        }
        ArrayList<Integer> siblingIDs = FolderObject.getSubfolderIds(parent, this.ctx, this.writeCon);
        for (Integer siblingID : siblingIDs) {
            if (siblingID == exclude || !this.getFolderFromMaster(siblingID).isVisible(entity)) continue;
            return;
        }
        ToDoPermission todo = (ToDoPermission)toRemove.get(parent);
        if (todo == null) {
            todo = new ToDoPermission(parent);
            toRemove.put(parent, (Object)todo);
        }
        if (isGroup) {
            todo.addGroup(entity);
        } else {
            todo.addUser(entity);
        }
        if (!this.getFolderFromMaster(parent).isNonSystemVisible(entity)) {
            this.hasVisibleSibling(this.getFolderFromMaster(parent).getParentFolderID(), parent, origin, entity, isGroup, toRemove);
        }
    }

    private void deleteSystemFolderReadPermission(int folderId, int entity) throws OXException, SQLException {
        OXFolderSQL.deleteSingleSystemPermission(folderId, entity, this.writeCon, this.ctx);
    }

    private void removeSystemPermissions(long lastModified, TIntObjectMap<ToDoPermission> toRemove) throws OXException, SQLException {
        TIntObjectIterator iterator = toRemove.iterator();
        int i = toRemove.size();
        while (i-- > 0) {
            int[] groups;
            int[] users;
            iterator.advance();
            int fid = iterator.key();
            ToDoPermission toDoPermission = (ToDoPermission)iterator.value();
            for (int user : users = toDoPermission.getUsers()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Auto-Delete system-folder-read permission for user " + UserStorage.getStorageUser(user, this.ctx).getDisplayName() + " from folder " + fid));
                }
                this.deleteSystemFolderReadPermission(fid, user);
            }
            for (int group : groups = toDoPermission.getGroups()) {
                if (LOG.isDebugEnabled()) {
                    try {
                        LOG.debug((Object)("Auto-Delete system-folder-read permission for group " + GroupStorage.getInstance().getGroup(group, this.ctx).getDisplayName() + " from folder " + fid));
                    }
                    catch (OXException e) {
                        LOG.trace((Object)"Logging failed", (Throwable)e);
                    }
                }
                this.deleteSystemFolderReadPermission(fid, group);
            }
            OXFolderSQL.updateLastModified(fid, lastModified, this.ctx.getMailadmin(), this.writeCon, this.ctx);
            ConditionTreeMapManagement.dropFor(this.ctx.getContextId());
            try {
                if (FolderCacheManager.isEnabled()) {
                    FolderCacheManager.getInstance().removeFolderObject(fid, this.ctx);
                }
                this.broadcastEvent(fid, true, ServerServiceRegistry.getInstance().getService(EventAdmin.class));
                if (FolderQueryCacheManager.isInitialized()) {
                    FolderQueryCacheManager.getInstance().invalidateContextQueries(this.session);
                }
                if (!CalendarCache.isInitialized()) continue;
                CalendarCache.getInstance().invalidateGroup(this.ctx.getContextId());
            }
            catch (OXException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }
}

