/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.oxfolder.console;

import com.openexchange.java.Charsets;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import javax.management.remote.JMXAuthenticator;
import javax.management.remote.JMXPrincipal;
import javax.security.auth.Subject;
import org.apache.commons.codec.binary.Base64;

final class JMXAuthenticatorImpl
implements JMXAuthenticator {
    private final String[] credentials;

    public JMXAuthenticatorImpl(String[] credentials) {
        this.credentials = new String[credentials.length];
        System.arraycopy(credentials, 0, this.credentials, 0, credentials.length);
    }

    @Override
    public Subject authenticate(Object credentials) {
        if (!(credentials instanceof String[])) {
            if (credentials == null) {
                throw new SecurityException("Credentials required");
            }
            throw new SecurityException("Credentials should be String[]");
        }
        String[] creds = (String[])credentials;
        if (creds.length != 2) {
            throw new SecurityException("Credentials should have 2 elements");
        }
        String username = creds[0];
        String password = creds[1];
        if (this.credentials[0].equals(username) && this.credentials[1].equals(password)) {
            return new Subject(true, Collections.singleton(new JMXPrincipal(username)), Collections.EMPTY_SET, Collections.EMPTY_SET);
        }
        throw new SecurityException("Invalid credentials");
    }

    private static String makeSHAPasswd(String raw) {
        MessageDigest md;
        try {
            md = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(JMXAuthenticatorImpl.class)).error((Object)e.getMessage(), (Throwable)e);
            return raw;
        }
        byte[] salt = new byte[]{};
        md.reset();
        md.update(raw.getBytes(Charsets.UTF_8));
        md.update(salt);
        try {
            return Charset.forName("US-ASCII").decode(ByteBuffer.wrap(Base64.encodeBase64((byte[])md.digest()))).toString();
        }
        catch (IllegalCharsetNameException e) {
            Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(JMXAuthenticatorImpl.class)).error((Object)e.getMessage(), (Throwable)e);
        }
        catch (UnsupportedCharsetException e) {
            Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(JMXAuthenticatorImpl.class)).error((Object)e.getMessage(), (Throwable)e);
        }
        return null;
    }
}

