/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.images;

import com.openexchange.java.Strings;
import com.openexchange.log.Log;
import javax.imageio.ImageIO;

public class ImageTransformationUtility {
    private static final org.apache.commons.logging.Log LOG = Log.loggerFor(ImageTransformationUtility.class);

    private ImageTransformationUtility() {
    }

    public static String getImageFormat(String value) {
        int idx;
        if (null == value) {
            LOG.debug((Object)"No format name specified, falling back to 'jpeg'.");
            return "jpeg";
        }
        String val = value;
        if (val.toLowerCase().startsWith("image/")) {
            val = val.substring(6);
        }
        if (0 < (idx = val.indexOf(59))) {
            val = val.substring(0, idx);
        }
        if ("pjpeg".equals(val)) {
            LOG.debug((Object)("Assuming 'jpeg' for image format " + val));
            return "jpeg";
        }
        if ("x-png".equals(val)) {
            LOG.debug((Object)("Assuming 'png' for image format " + val));
            return "png";
        }
        if ("x-ms-bmp".equals(val)) {
            LOG.debug((Object)("Assuming 'bmp' for image format " + val));
            return "bmp";
        }
        return val;
    }

    public static boolean canRead(String formatName) {
        String tmp = Strings.toLowerCase((CharSequence)formatName);
        if ("vnd.microsoft.icon".equals(tmp) || "x-icon".equals(tmp)) {
            return false;
        }
        for (String readerFormatName : ImageIO.getReaderFormatNames()) {
            if (!Strings.toLowerCase((CharSequence)readerFormatName).equals(tmp)) continue;
            return true;
        }
        return false;
    }

    public static boolean supportsTransparency(String formatName) {
        return false == "jpeg".equalsIgnoreCase(formatName) && false == "jpg".equalsIgnoreCase(formatName);
    }
}

