/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.console;

import java.io.PrintStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

public class TableWriter {
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z");
    private final PrintStream ps;
    private final ColumnFormat[] formats;
    private final List<List<Object>> data;

    public TableWriter(PrintStream ps, ColumnFormat[] formats, List<List<Object>> data) {
        this.ps = ps;
        this.formats = formats;
        this.data = data;
    }

    private void determineAutoWidth() {
        for (int i = 0; i < this.formats.length; ++i) {
            if (this.formats[i].getWidth() != -1) continue;
            for (List<Object> row : this.data) {
                this.formats[i].setWidth(Math.max(this.formats[i].getWidth(), this.toString(row.get(i)).length()));
            }
        }
    }

    private String generateFormatString() {
        StringBuilder retval = new StringBuilder();
        for (ColumnFormat format : this.formats) {
            retval.append('%');
            switch (format.getAlign()) {
                case LEFT: {
                    retval.append('-');
                    break;
                }
            }
            retval.append(format.getWidth());
            switch (format.getConversion()) {
                case DATE: {
                    retval.append("tc");
                    break;
                }
                default: {
                    retval.append('s');
                }
            }
            retval.append(' ');
        }
        retval.setCharAt(retval.length() - 1, '\n');
        return retval.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String toString(Object obj) {
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof Date) {
            DateFormat dateFormat = DATE_FORMAT;
            synchronized (dateFormat) {
                return DATE_FORMAT.format((Date)obj);
            }
        }
        return obj.toString();
    }

    public void write() {
        this.determineAutoWidth();
        String format = this.generateFormatString();
        for (List<Object> row : this.data) {
            Object[] args = new Object[row.size()];
            for (int i = 0; i < row.size(); ++i) {
                args[i] = this.toString(row.get(i));
            }
            this.ps.format(format, args);
        }
    }

    public static class ColumnFormat {
        public static final int AUTO_WIDTH = -1;
        private final Align align;
        private int width;
        private final Conversion conversion;

        public ColumnFormat(Align align) {
            this(align, -1, Conversion.STRING);
        }

        public ColumnFormat(Align align, Conversion conversion) {
            this(align, -1, conversion);
        }

        public ColumnFormat(Align align, int width, Conversion conversion) {
            this.align = align;
            this.width = width;
            this.conversion = conversion;
        }

        public Align getAlign() {
            return this.align;
        }

        public int getWidth() {
            return this.width;
        }

        public void setWidth(int width) {
            this.width = width;
        }

        public Conversion getConversion() {
            return this.conversion;
        }

        public static enum Conversion {
            STRING,
            DATE;

        }

        public static enum Align {
            LEFT,
            RIGHT;

        }
    }
}

