/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.sessiond.impl;

import com.openexchange.sessiond.impl.IPAddressUtil;
import java.math.BigInteger;
import java.util.regex.Pattern;
import org.apache.commons.net.util.SubnetUtils;

public class SubnetMask {
    private static final Pattern ipv4Dotted = Pattern.compile("(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})");
    private static final Pattern ipv4CIDR = Pattern.compile("/(\\d{1,2})");
    private static final Pattern ipv6CIDR = Pattern.compile("/(\\d{1,3})");
    private String v4Mask;
    private BigInteger v6Mask;
    private boolean v4CIDR;

    public SubnetMask(String v4, String v6) {
        if (v4 != null) {
            if (ipv4Dotted.matcher(v4).matches()) {
                this.v4Mask = v4;
            } else if (ipv4CIDR.matcher(v4).matches()) {
                this.v4Mask = v4;
                this.v4CIDR = true;
            } else if (!v4.trim().equals("")) {
                throw new IllegalArgumentException(v4 + " is neither a valid CIDR nor a valid dotted representation of an IPv4 subnet mask.");
            }
        }
        if (v6 != null) {
            if (ipv6CIDR.matcher(v6).matches()) {
                this.v6Mask = BigInteger.valueOf(2L).pow(128).subtract(BigInteger.valueOf(2L).pow(128 - Integer.parseInt(v6.substring(1))));
            } else if (!v6.trim().equals("")) {
                throw new IllegalArgumentException(v6 + " is not a valid CIDR representation of an IPv6 subnet mask.");
            }
        }
    }

    public boolean areInSameSubnet(String firstIP, String secondIP) {
        if (firstIP == null || secondIP == null) {
            return false;
        }
        if (this.v4Mask != null && ipv4Dotted.matcher(firstIP).matches() && ipv4Dotted.matcher(secondIP).matches()) {
            SubnetUtils subnet = this.v4CIDR ? new SubnetUtils(firstIP + this.v4Mask) : new SubnetUtils(firstIP, this.v4Mask);
            subnet.setInclusiveHostCount(true);
            return subnet.getInfo().isInRange(secondIP);
        }
        if (this.v6Mask != null) {
            byte[] firstV6Octets = IPAddressUtil.textToNumericFormatV6(firstIP);
            if (firstV6Octets == null) {
                return false;
            }
            byte[] secondV6Octets = IPAddressUtil.textToNumericFormatV6(secondIP);
            if (secondV6Octets == null) {
                return false;
            }
            BigInteger firstV6 = SubnetMask.ipToBigIntegerV6(firstV6Octets);
            BigInteger secondV6 = SubnetMask.ipToBigIntegerV6(secondV6Octets);
            return firstV6.and(this.v6Mask).equals(secondV6.and(this.v6Mask));
        }
        return false;
    }

    private static BigInteger ipToBigIntegerV6(byte[] octets) {
        BigInteger result = BigInteger.ZERO;
        for (int i = 0; i < octets.length; ++i) {
            result = result.or(BigInteger.valueOf(octets[i]).and(BigInteger.valueOf(255L)));
            if (i >= octets.length - 1) continue;
            result = result.shiftLeft(8);
        }
        return result;
    }
}

