/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.report.internal;

import com.openexchange.config.ConfigurationService;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.ldap.UserImpl;
import com.openexchange.log.Log;
import com.openexchange.login.Interface;
import com.openexchange.login.LoginHandlerService;
import com.openexchange.login.LoginRequest;
import com.openexchange.login.LoginResult;
import com.openexchange.user.UserService;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class LastLoginRecorder
implements LoginHandlerService {
    private static final org.apache.commons.logging.Log LOG = Log.loggerFor(LastLoginRecorder.class);
    private int maxClientCount = -1;
    private final UserService userService;
    private static final String[] KNOWN_CLIENTS = new String[]{"com.openexchange.ox.gui.dhtml", "open-xchange-appsuite", "com.openexchange.mobileapp", "OpenXchange.HTTPClient.OXAddIn", "OpenXchange.HTTPClient.OXNotifier", "com.open-xchange.updater.olox1", "com.open-xchange.updater.olox2"};

    public LastLoginRecorder(ConfigurationService confService, UserService userService) {
        this.userService = userService;
        this.readConfiguration(confService);
    }

    private void readConfiguration(ConfigurationService confService) {
        this.maxClientCount = confService.getIntProperty("com.openexchange.user.maxClientCount", -1);
    }

    @Override
    public void handleLogin(LoginResult login) throws OXException {
        LoginRequest request = login.getRequest();
        String client = request.getClient();
        if (null == client) {
            client = request.getInterface().toString();
        }
        if (null == client) {
            return;
        }
        Context context = login.getContext();
        User user = login.getUser();
        if (!LastLoginRecorder.isWhitelistedClient(client) && this.maxClientCount > 0) {
            int count = 0;
            for (String origKey : user.getAttributes().keySet()) {
                if (!origKey.startsWith("client:") || ++count <= this.maxClientCount) continue;
                LOG.warn((Object)("Login of client " + client + " for login " + login + " (Context: " + context.getContextId() + ", User: " + user.getId() + ") will not be recorded in the database."));
            }
        }
        LastLoginRecorder.updateLastLogin(this.userService, client, user, context);
    }

    static void updateLastLogin(UserService userService, String client, User origUser, Context context) throws OXException {
        if (context.isReadOnly()) {
            return;
        }
        HashMap<String, Set<String>> attributes = new HashMap<String, Set<String>>(origUser.getAttributes());
        attributes.put("client:" + client, new HashSet<String>(Arrays.asList(Long.toString(System.currentTimeMillis()))));
        UserImpl newUser = new UserImpl();
        newUser.setId(origUser.getId());
        newUser.setAttributes(attributes);
        userService.updateUser(newUser, context);
    }

    private static boolean isWhitelistedClient(String client) {
        for (Interface interface_ : Interface.values()) {
            if (!interface_.toString().equals(client)) continue;
            return true;
        }
        for (String string : KNOWN_CLIENTS) {
            if (!string.equals(client)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void handleLogout(LoginResult logout) {
    }
}

