/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mailaccount.internal;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.mailaccount.Attribute;
import com.openexchange.mailaccount.MailAccount;
import com.openexchange.mailaccount.MailAccountDescription;
import com.openexchange.mailaccount.MailAccountExceptionCodes;
import com.openexchange.mailaccount.MailAccountStorageService;
import com.openexchange.mailaccount.internal.Sanitizer;
import com.openexchange.session.Session;
import com.openexchange.tools.net.URIDefaults;
import java.sql.Connection;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

final class SanitizingStorageService
implements MailAccountStorageService {
    private static final int URI_ERROR_NUMBER = MailAccountExceptionCodes.URI_PARSE_FAILED.getNumber();
    private static final String PREFIX = MailAccountExceptionCodes.URI_PARSE_FAILED.getPrefix();
    private final MailAccountStorageService storageService;

    SanitizingStorageService(MailAccountStorageService storageService) {
        this.storageService = storageService;
    }

    private static boolean isURIError(OXException candidate) {
        return PREFIX.equals(candidate.getPrefix()) && URI_ERROR_NUMBER == candidate.getCode();
    }

    @Override
    public void invalidateMailAccount(int id, int user, int cid) throws OXException {
        this.storageService.invalidateMailAccount(id, user, cid);
    }

    @Override
    public void invalidateMailAccounts(int user, int cid) throws OXException {
        this.storageService.invalidateMailAccounts(user, cid);
    }

    @Override
    public MailAccount getMailAccount(int id, int user, int cid) throws OXException {
        try {
            return this.storageService.getMailAccount(id, user, cid);
        }
        catch (OXException e) {
            if (!SanitizingStorageService.isURIError(e)) {
                throw e;
            }
            Sanitizer.sanitize(user, cid, this.storageService);
            return this.storageService.getMailAccount(id, user, cid);
        }
    }

    @Override
    public MailAccount[] getUserMailAccounts(int user, int cid) throws OXException {
        try {
            return this.storageService.getUserMailAccounts(user, cid);
        }
        catch (OXException e) {
            if (!SanitizingStorageService.isURIError(e)) {
                throw e;
            }
            Sanitizer.sanitize(user, cid, this.storageService);
            return this.storageService.getUserMailAccounts(user, cid);
        }
    }

    @Override
    public MailAccount[] getUserMailAccounts(int user, int cid, Connection con) throws OXException {
        try {
            return this.storageService.getUserMailAccounts(user, cid, con);
        }
        catch (OXException e) {
            if (!SanitizingStorageService.isURIError(e)) {
                throw e;
            }
            Sanitizer.sanitize(user, cid, this.storageService);
            return this.storageService.getUserMailAccounts(user, cid, con);
        }
    }

    @Override
    public MailAccount getDefaultMailAccount(int user, int cid) throws OXException {
        return this.storageService.getDefaultMailAccount(user, cid);
    }

    @Override
    public void updateMailAccount(MailAccountDescription mailAccount, Set<Attribute> attributes, int user, int cid, Session session) throws OXException {
        this.storageService.updateMailAccount(mailAccount, attributes, user, cid, session);
    }

    @Override
    public void updateMailAccount(MailAccountDescription mailAccount, Set<Attribute> attributes, int user, int cid, Session session, Connection con, boolean changePrimary) throws OXException {
        this.storageService.updateMailAccount(mailAccount, attributes, user, cid, session, con, changePrimary);
    }

    @Override
    public void updateMailAccount(MailAccountDescription mailAccount, int user, int cid, Session session) throws OXException {
        this.storageService.updateMailAccount(mailAccount, user, cid, session);
    }

    @Override
    public int insertMailAccount(MailAccountDescription mailAccount, int user, Context ctx, Session session) throws OXException {
        return this.storageService.insertMailAccount(mailAccount, user, ctx, session);
    }

    @Override
    public int insertMailAccount(MailAccountDescription mailAccount, int user, Context ctx, Session session, Connection con) throws OXException {
        return this.storageService.insertMailAccount(mailAccount, user, ctx, session, con);
    }

    @Override
    public void deleteMailAccount(int id, Map<String, Object> properties, int user, int cid) throws OXException {
        this.storageService.deleteMailAccount(id, properties, user, cid);
    }

    @Override
    public void deleteMailAccount(int id, Map<String, Object> properties, int user, int cid, boolean deletePrimary) throws OXException {
        this.storageService.deleteMailAccount(id, properties, user, cid, deletePrimary);
    }

    @Override
    public void deleteMailAccount(int id, Map<String, Object> properties, int user, int cid, boolean deletePrimary, Connection con) throws OXException {
        this.storageService.deleteMailAccount(id, properties, user, cid, deletePrimary, con);
    }

    @Override
    public MailAccount[] resolveLogin(String login, int cid) throws OXException {
        return this.storageService.resolveLogin(login, cid);
    }

    @Override
    public MailAccount[] resolveLogin(String login, String serverUrl, int cid) throws OXException {
        return this.storageService.resolveLogin(login, serverUrl, cid);
    }

    @Override
    public MailAccount[] resolvePrimaryAddr(String primaryAddress, int cid) throws OXException {
        return this.storageService.resolvePrimaryAddr(primaryAddress, cid);
    }

    @Override
    public int getByPrimaryAddress(String primaryAddress, int user, int cid) throws OXException {
        return this.storageService.getByPrimaryAddress(primaryAddress, user, cid);
    }

    @Override
    public int[] getByHostNames(Collection<String> hostNames, int user, int cid) throws OXException {
        return this.storageService.getByHostNames(hostNames, user, cid);
    }

    @Override
    public MailAccount getTransportAccountForID(int id, int user, int cid) throws OXException {
        try {
            return this.storageService.getTransportAccountForID(id, user, cid);
        }
        catch (OXException e) {
            if (!SanitizingStorageService.isURIError(e)) {
                throw e;
            }
            Sanitizer.sanitize(user, cid, this.storageService, URIDefaults.SMTP, "smtp://localhost:25");
            return this.storageService.getTransportAccountForID(id, user, cid);
        }
    }

    @Override
    public void migratePasswords(String oldSecret, String newSecret, Session session) throws OXException {
        this.storageService.migratePasswords(oldSecret, newSecret, session);
    }

    @Override
    public void cleanUp(String secret, Session session) throws OXException {
        this.storageService.cleanUp(secret, session);
    }

    @Override
    public void removeUnrecoverableItems(String secret, Session session) throws OXException {
        this.storageService.removeUnrecoverableItems(secret, session);
    }

    @Override
    public boolean hasAccounts(Session session) throws OXException {
        return this.storageService.hasAccounts(session);
    }
}

