/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mailaccount.internal;

import com.openexchange.exception.OXException;
import com.openexchange.java.StringAllocator;
import com.openexchange.java.Strings;
import com.openexchange.log.LogFactory;
import com.openexchange.mail.config.MailProperties;
import com.openexchange.mail.transport.config.TransportProperties;
import com.openexchange.mailaccount.MailAccount;
import com.openexchange.mailaccount.MailAccountExceptionCodes;
import com.openexchange.tools.net.URIDefaults;
import com.openexchange.tools.net.URIParser;
import com.openexchange.tools.net.URITools;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.mail.internet.idn.IDNA;
import org.apache.commons.logging.Log;

public abstract class AbstractMailAccount
implements MailAccount {
    private static final Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(AbstractMailAccount.class));
    private static final long serialVersionUID = -641194838598605274L;
    protected int id;
    protected String login;
    protected String password;
    protected String transportLogin;
    protected String transportPassword;
    protected String mailServer;
    protected int mailPort = 143;
    protected String mailProtocol;
    protected boolean mailSecure;
    protected String transportServer;
    protected int transportPort = 25;
    protected String transportProtocol;
    protected boolean transportSecure;
    protected String name;
    protected String primaryAddress;
    protected String personal;
    protected String replyTo;
    protected int userId;
    protected String spamHandler;
    protected String trash;
    protected String archive;
    protected String sent;
    protected String drafts;
    protected String spam;
    protected String confirmedSpam;
    protected String confirmedHam;
    protected String mailServerUrl;
    protected String transportServerUrl;
    protected boolean unifiedINBOXEnabled;
    protected String trashFullname;
    protected String archiveFullname;
    protected String sentFullname;
    protected String draftsFullname;
    protected String spamFullname;
    protected String confirmedSpamFullname;
    protected String confirmedHamFullname;
    protected Map<String, String> properties = new HashMap<String, String>(4);

    protected AbstractMailAccount() {
        String transportProvider = TransportProperties.getInstance().getDefaultTransportProvider();
        this.transportProtocol = transportProvider == null ? "smtp" : transportProvider;
        String mailProvider = MailProperties.getInstance().getDefaultMailProvider();
        this.mailProtocol = mailProvider == null ? "imap" : mailProvider;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public String getLogin() {
        return this.login;
    }

    @Override
    public String getMailServer() {
        return this.mailServer;
    }

    @Override
    public int getMailPort() {
        return this.mailPort;
    }

    @Override
    public String getMailProtocol() {
        return this.mailProtocol;
    }

    @Override
    public boolean isMailSecure() {
        return this.mailSecure;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public String getPrimaryAddress() {
        return this.primaryAddress;
    }

    @Override
    public String getPersonal() {
        return this.personal;
    }

    @Override
    public String getReplyTo() {
        if (AbstractMailAccount.isEmpty(this.replyTo)) {
            return this.properties.get("replyto");
        }
        return this.replyTo;
    }

    @Override
    public String getTransportServer() {
        return this.transportServer;
    }

    @Override
    public int getTransportPort() {
        return this.transportPort;
    }

    @Override
    public String getTransportProtocol() {
        return this.transportProtocol;
    }

    @Override
    public boolean isTransportSecure() {
        return this.transportSecure;
    }

    @Override
    public int getUserId() {
        return this.userId;
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPrimaryAddress(String primaryAddress) {
        this.primaryAddress = primaryAddress == null ? primaryAddress : IDNA.toIDN((String)primaryAddress);
    }

    public void setPersonal(String personal) {
        this.personal = personal;
    }

    public void setReplyTo(String replyTo) {
        this.replyTo = replyTo;
        if (AbstractMailAccount.isEmpty(replyTo)) {
            this.properties.remove("replyto");
        } else {
            this.properties.put("replyto", replyTo);
        }
    }

    public void setUserId(int userId) {
        this.userId = userId;
    }

    @Override
    public String getDrafts() {
        return this.drafts;
    }

    @Override
    public String getSent() {
        return this.sent;
    }

    @Override
    public String getSpam() {
        return this.spam;
    }

    @Override
    public String getArchive() {
        return this.archive;
    }

    @Override
    public String getTrash() {
        return this.trash;
    }

    @Override
    public String getConfirmedHam() {
        return this.confirmedHam;
    }

    @Override
    public String getConfirmedSpam() {
        return this.confirmedSpam;
    }

    @Override
    public String getSpamHandler() {
        return this.spamHandler;
    }

    public void setTrash(String trash) {
        this.trash = trash;
    }

    public void setArchive(String archive) {
        this.archive = archive;
    }

    public void setSent(String sent) {
        this.sent = sent;
    }

    public void setDrafts(String drafts) {
        this.drafts = drafts;
    }

    public void setSpam(String spam) {
        this.spam = spam;
    }

    public void setConfirmedSpam(String confirmedSpam) {
        this.confirmedSpam = confirmedSpam;
    }

    public void setConfirmedHam(String confirmedHam) {
        this.confirmedHam = confirmedHam;
    }

    public void setSpamHandler(String spamHandler) {
        this.spamHandler = spamHandler;
    }

    public void setMailServer(String mailServer) {
        this.mailServerUrl = null;
        this.mailServer = mailServer == null ? null : IDNA.toUnicode((String)mailServer);
    }

    public void setMailPort(int mailPort) {
        this.mailServerUrl = null;
        this.mailPort = mailPort;
    }

    public void setMailProtocol(String mailProtocol) {
        this.mailServerUrl = null;
        this.mailProtocol = mailProtocol;
    }

    public void setMailSecure(boolean mailSecure) {
        this.mailServerUrl = null;
        this.mailSecure = mailSecure;
    }

    public void setTransportServer(String transportServer) {
        this.transportServerUrl = null;
        this.transportServer = transportServer == null ? null : IDNA.toUnicode((String)transportServer);
    }

    public void setTransportPort(int transportPort) {
        this.transportServerUrl = null;
        this.transportPort = transportPort;
    }

    public void setTransportProtocol(String transportProtocol) {
        this.transportServerUrl = null;
        this.transportProtocol = transportProtocol;
    }

    public void setTransportSecure(boolean transportSecure) {
        this.transportServerUrl = null;
        this.transportSecure = transportSecure;
    }

    @Override
    public String generateMailServerURL() {
        if (null != this.mailServerUrl) {
            return this.mailServerUrl;
        }
        if (AbstractMailAccount.isEmpty(this.mailServer)) {
            return null;
        }
        String protocol = this.mailSecure ? this.mailProtocol + 's' : this.mailProtocol;
        try {
            this.mailServerUrl = URITools.generateURI(protocol, IDNA.toASCII((String)this.mailServer), this.mailPort).toString();
            return this.mailServerUrl;
        }
        catch (URISyntaxException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            StringAllocator sb = new StringAllocator(32);
            sb.append(this.mailProtocol);
            if (this.mailSecure) {
                sb.append('s');
            }
            this.mailServerUrl = sb.append("://").append(this.mailServer).append(':').append(this.mailPort).toString();
            return this.mailServerUrl;
        }
    }

    public void parseMailServerURL(String mailServerURL) throws OXException {
        try {
            this.setMailServer(URIParser.parse(IDNA.toASCII((String)mailServerURL), URIDefaults.IMAP));
        }
        catch (URISyntaxException e) {
            throw MailAccountExceptionCodes.URI_PARSE_FAILED.create(e, mailServerURL);
        }
    }

    public void setMailServer(URI mailServer) {
        if (null == mailServer) {
            this.setMailServer("");
        } else {
            String protocol = mailServer.getScheme();
            if (protocol.endsWith("s")) {
                this.setMailSecure(true);
                this.setMailProtocol(protocol.substring(0, protocol.length() - 1));
            } else {
                this.setMailSecure(false);
                this.setMailProtocol(protocol);
            }
            this.setMailServer(URITools.getHost(mailServer));
            this.setMailPort(mailServer.getPort());
        }
    }

    public void parseTransportServerURL(String transportServerURL) throws OXException {
        if (null == transportServerURL) {
            this.setTransportServer((String)null);
            return;
        }
        try {
            this.setTransportServer(URIParser.parse(IDNA.toASCII((String)transportServerURL), URIDefaults.SMTP));
        }
        catch (URISyntaxException e) {
            this.setTransportServer((String)null);
            return;
        }
    }

    public void setTransportServer(URI transportServer) {
        if (null == transportServer) {
            this.setTransportServer("");
        } else {
            String protocol = transportServer.getScheme();
            if (protocol.endsWith("s")) {
                this.setTransportSecure(true);
                this.setTransportProtocol(protocol.substring(0, protocol.length() - 1));
            } else {
                this.setTransportSecure(false);
                this.setTransportProtocol(protocol);
            }
            this.setTransportServer(URITools.getHost(transportServer));
            this.setTransportPort(transportServer.getPort());
        }
    }

    @Override
    public String generateTransportServerURL() {
        if (null != this.transportServerUrl) {
            return this.transportServerUrl;
        }
        if (AbstractMailAccount.isEmpty(this.transportServer)) {
            return null;
        }
        String protocol = this.transportSecure ? this.transportProtocol + 's' : this.transportProtocol;
        try {
            this.transportServerUrl = URITools.generateURI(protocol, IDNA.toASCII((String)this.transportServer), this.transportPort).toString();
            return this.transportServerUrl;
        }
        catch (URISyntaxException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            StringAllocator sb = new StringAllocator(32);
            sb.append(this.transportProtocol);
            if (this.transportSecure) {
                sb.append('s');
            }
            this.transportServerUrl = sb.append("://").append(this.transportServer).append(':').append(this.transportPort).toString();
            return this.transportServerUrl;
        }
    }

    @Override
    public String getTransportLogin() {
        if (null == this.transportLogin) {
            return this.getLogin();
        }
        return this.transportLogin;
    }

    @Override
    public String getTransportPassword() {
        if (null == this.transportPassword) {
            return this.getPassword();
        }
        return this.transportPassword;
    }

    public void setTransportLogin(String transportLogin) {
        this.transportLogin = transportLogin;
    }

    public void setTransportPassword(String transportPassword) {
        this.transportPassword = transportPassword;
    }

    @Override
    public boolean isUnifiedINBOXEnabled() {
        return this.unifiedINBOXEnabled;
    }

    public void setUnifiedINBOXEnabled(boolean unifiedINBOXEnabled) {
        this.unifiedINBOXEnabled = unifiedINBOXEnabled;
    }

    @Override
    public String getTrashFullname() {
        return this.trashFullname;
    }

    public void setTrashFullname(String trashFullname) {
        this.trashFullname = trashFullname;
    }

    @Override
    public String getArchiveFullname() {
        return this.archiveFullname;
    }

    public void setArchiveFullname(String archiveFullname) {
        this.archiveFullname = archiveFullname;
    }

    @Override
    public String getSentFullname() {
        return this.sentFullname;
    }

    public void setSentFullname(String sentFullname) {
        this.sentFullname = sentFullname;
    }

    @Override
    public String getDraftsFullname() {
        return this.draftsFullname;
    }

    public void setDraftsFullname(String draftsFullname) {
        this.draftsFullname = draftsFullname;
    }

    @Override
    public String getSpamFullname() {
        return this.spamFullname;
    }

    public void setSpamFullname(String spamFullname) {
        this.spamFullname = spamFullname;
    }

    @Override
    public String getConfirmedSpamFullname() {
        return this.confirmedSpamFullname;
    }

    public void setConfirmedSpamFullname(String confirmedSpamFullname) {
        this.confirmedSpamFullname = confirmedSpamFullname;
    }

    @Override
    public String getConfirmedHamFullname() {
        return this.confirmedHamFullname;
    }

    public void setConfirmedHamFullname(String confirmedHamFullname) {
        this.confirmedHamFullname = confirmedHamFullname;
    }

    @Override
    public Map<String, String> getProperties() {
        if (this.properties.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, String> clone = new HashMap<String, String>(this.properties.size());
        clone.putAll(this.properties);
        if (null != this.replyTo) {
            clone.put("replyto", this.replyTo);
        }
        return clone;
    }

    public void setProperties(Map<String, String> properties) {
        if (null == properties) {
            this.properties = new HashMap<String, String>(4);
        } else if (properties.isEmpty()) {
            this.properties = new HashMap<String, String>(4);
        } else {
            for (Map.Entry<String, String> e : properties.entrySet()) {
                if (!"replyto".equals(e.getKey())) continue;
                this.replyTo = e.getValue();
                break;
            }
            this.properties = new HashMap<String, String>(properties.size());
            this.properties.putAll(properties);
        }
    }

    @Override
    public void addProperty(String name, String value) {
        if (this.properties.isEmpty()) {
            this.properties = new HashMap<String, String>(4);
        }
        if ("replyto".equals(name)) {
            this.replyTo = value;
        }
        this.properties.put(name, value);
    }

    public String toString() {
        StringAllocator sb = new StringAllocator(128);
        sb.append(" id=").append(this.getId()).append(" user=").append(this.getUserId());
        sb.append("\nname=").append(this.getName()).append(" primary-address=").append(this.getPrimaryAddress());
        sb.append("\nmail-server=").append(this.generateMailServerURL()).append(" transport-server=").append(this.generateTransportServerURL());
        return sb.toString();
    }

    private static boolean isEmpty(String string) {
        if (null == string) {
            return true;
        }
        int len = string.length();
        boolean isWhitespace = true;
        for (int i = 0; isWhitespace && i < len; ++i) {
            isWhitespace = Strings.isWhitespace((char)string.charAt(i));
        }
        return isWhitespace;
    }
}

