/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.utils;

import com.openexchange.exception.OXException;
import com.openexchange.java.StringAllocator;
import com.openexchange.mailaccount.MailAccountExceptionCodes;
import com.openexchange.tools.net.URIDefaults;
import com.openexchange.tools.net.URIParser;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Locale;

public final class ProviderUtility {
    private ProviderUtility() {
    }

    public static String toSocketAddrString(String serverUrl, final int defaultPort) throws OXException {
        URI uri;
        try {
            uri = URIParser.parse(serverUrl, new URIDefaults(){

                @Override
                public String getProtocol() {
                    return null;
                }

                @Override
                public String getSSLProtocol() {
                    return null;
                }

                @Override
                public int getPort() {
                    return defaultPort;
                }

                @Override
                public int getSSLPort() {
                    return defaultPort;
                }
            });
        }
        catch (URISyntaxException e) {
            throw MailAccountExceptionCodes.URI_PARSE_FAILED.create(e, serverUrl);
        }
        return new StringAllocator(uri.getHost()).append(':').append(uri.getPort()).toString();
    }

    public static String extractProtocol(String serverUrl, String fallback) {
        if (serverUrl == null) {
            return fallback;
        }
        int len = serverUrl.length();
        char c = '\u0000';
        String protocol = null;
        for (int i = 0; i < len && (c = serverUrl.charAt(i)) != '/'; ++i) {
            if (c != ':' || (c = serverUrl.charAt(i + 1)) != '/' || (c = serverUrl.charAt(i + 2)) != '/') continue;
            String s = serverUrl.substring(0, i).toLowerCase(Locale.ENGLISH);
            if (!ProviderUtility.isValidProtocol(s)) break;
            protocol = s;
            break;
        }
        if (null == protocol) {
            return fallback;
        }
        return protocol;
    }

    private static boolean isValidProtocol(String protocol) {
        int len = protocol.length();
        if (len < 1) {
            return false;
        }
        char c = protocol.charAt(0);
        if (!Character.isLetter(c)) {
            return false;
        }
        for (int i = 1; i < len; ++i) {
            c = protocol.charAt(i);
            if (Character.isLetterOrDigit(c) || c == '.' || c == '+' || c == '-') continue;
            return false;
        }
        return true;
    }
}

