/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.utils;

import com.openexchange.java.StringAllocator;
import com.openexchange.java.Strings;
import com.openexchange.mail.FullnameArgument;
import com.openexchange.mail.config.MailProperties;
import com.openexchange.mailaccount.UnifiedInboxManagement;
import com.sun.mail.imap.protocol.BASE64MailboxDecoder;
import com.sun.mail.imap.protocol.BASE64MailboxEncoder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class MailFolderUtility {
    private static final String DEFAULT_FOLDER_ID = "default";
    private static final int LEN = "default".length();
    private static final Pattern P_FOLDER;

    private MailFolderUtility() {
    }

    public static String encode(String fullName) {
        return BASE64MailboxEncoder.encode((String)fullName);
    }

    public static String decode(String encoded) {
        return BASE64MailboxDecoder.decode((String)encoded);
    }

    public static FullnameArgument prepareMailFolderParam(String fullnameArgument) {
        int accountId;
        int index;
        if (fullnameArgument == null) {
            return null;
        }
        if (!fullnameArgument.startsWith(DEFAULT_FOLDER_ID)) {
            return new FullnameArgument(fullnameArgument);
        }
        int len = fullnameArgument.length();
        char separator = MailProperties.getInstance().getDefaultSeparator();
        char c = '\u0000';
        for (index = LEN; index < len && Character.isDigit(c = fullnameArgument.charAt(index)) && c != separator; ++index) {
        }
        try {
            accountId = index == LEN ? 0 : Integer.parseInt(fullnameArgument.substring(LEN, index));
        }
        catch (NumberFormatException e) {
            IllegalArgumentException err = new IllegalArgumentException("Mail account identifier is not a number: " + fullnameArgument);
            err.initCause(e);
            throw err;
        }
        if (index >= len) {
            return new FullnameArgument(accountId, DEFAULT_FOLDER_ID);
        }
        return new FullnameArgument(accountId, fullnameArgument.substring(index + 1));
    }

    public static boolean equalsFullname(String fullnameArgument, String fullname) {
        if (fullnameArgument == null) {
            return fullname == null;
        }
        return MailFolderUtility.prepareMailFolderParam(fullnameArgument).getFullname().equals(fullname);
    }

    public static String prepareFullname(int accountId, String fullname) {
        if (fullname == null) {
            return null;
        }
        int length = fullname.length();
        if (DEFAULT_FOLDER_ID.equals(fullname) || 0 == length) {
            return new StringAllocator(length + 4).append(fullname).append(accountId).toString();
        }
        if (fullname.startsWith(DEFAULT_FOLDER_ID)) {
            String tmpFullname = MailFolderUtility.prepareMailFolderParam(fullname).getFullname();
            if (DEFAULT_FOLDER_ID.equals(tmpFullname)) {
                return new StringAllocator(length + 4).append(fullname).append(tmpFullname).toString();
            }
            return new StringAllocator(LEN + length + 4).append(DEFAULT_FOLDER_ID).append(accountId).append(MailProperties.getInstance().getDefaultSeparator()).append(tmpFullname).toString();
        }
        return new StringAllocator(LEN + length + 4).append(DEFAULT_FOLDER_ID).append(accountId).append(MailProperties.getInstance().getDefaultSeparator()).append(fullname).toString();
    }

    public static boolean isEmpty(String string) {
        if (null == string) {
            return true;
        }
        int len = string.length();
        boolean isWhitespace = true;
        for (int i = 0; isWhitespace && i < len; ++i) {
            isWhitespace = Strings.isWhitespace((char)string.charAt(i));
        }
        return isWhitespace;
    }

    public static String sanitizeFullName(String fullName) {
        if (null == fullName || fullName.indexOf(DEFAULT_FOLDER_ID) < 0) {
            return fullName;
        }
        Matcher m = P_FOLDER.matcher(fullName);
        return m.matches() ? m.group(1) : fullName;
    }

    static {
        StringBuilder sb = new StringBuilder(64);
        sb.append("(?:");
        boolean first = true;
        for (String name : UnifiedInboxManagement.KNOWN_FOLDERS) {
            if (first) {
                first = false;
            } else {
                sb.append('|');
            }
            sb.append(name);
        }
        sb.append(')');
        sb.append("[./]").append(DEFAULT_FOLDER_ID).append("[0-9]+[./](.+)");
        P_FOLDER = Pattern.compile(sb.toString());
    }
}

