/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.usersetting;

import com.openexchange.exception.OXException;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.mailaccount.MailAccountStorageService;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.spamhandler.SpamHandlerRegistry;
import java.io.Serializable;
import javax.mail.internet.idn.IDNA;

public final class UserSettingMail
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -5787223065275414178L;
    private static final transient org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(UserSettingMail.class));
    public static final int INT_DISPLAY_HTML_INLINE_CONTENT = 1;
    public static final int INT_USE_COLOR_QUOTE = 2;
    public static final int INT_SHOW_GRAPHIC_EMOTICONS = 4;
    public static final int INT_HARD_DELETE_MSGS = 8;
    public static final int INT_FORWARD_AS_ATTACHMENT = 16;
    public static final int INT_APPEND_VCARD = 32;
    public static final int INT_NOTIFY_ON_READ_ACK = 64;
    public static final int INT_MSG_PREVIEW = 128;
    public static final int INT_NOTIFY_APPOINTMENTS = 256;
    public static final int INT_NOTIFY_TASKS = 512;
    public static final int INT_IGNORE_ORIGINAL_TEXT_ON_REPLY = 1024;
    public static final int INT_NO_COPY_INTO_SENT_FOLDER = 2048;
    public static final int INT_SPAM_ENABLED = 4096;
    public static final int INT_TEXT_ONLY_COMPOSE = 8192;
    public static final int INT_ALLOW_HTML_IMAGES = 16384;
    public static final int INT_NOTIFY_APPOINTMENTS_CONFIRM_OWNER = 32768;
    public static final int INT_NOTIFY_APPOINTMENTS_CONFIRM_PARTICIPANT = 65536;
    public static final int INT_NOTIFY_TASKS_CONFIRM_OWNER = 131072;
    public static final int INT_NOTIFY_TASKS_CONFIRM_PARTICIPANT = 262144;
    public static final int INT_REPLY_ALL_CC = 524288;
    public static final int MSG_FORMAT_TEXT_ONLY = 1;
    public static final int MSG_FORMAT_HTML_ONLY = 2;
    public static final int MSG_FORMAT_BOTH = 3;
    private final int userId;
    private final int cid;
    private boolean modifiedDuringSession;
    private boolean displayHtmlInlineContent;
    private boolean suppressHTMLAlternativePart;
    private boolean useColorQuote;
    private boolean showGraphicEmoticons;
    private boolean hardDeleteMsgs;
    private boolean forwardAsAttachment;
    private boolean appendVCard;
    private boolean notifyOnReadAck;
    private boolean notifyAppointments;
    private boolean notifyTasks;
    private boolean notifyAppointmentsConfirmOwner;
    private boolean notifyAppointmentsConfirmParticipant;
    private boolean notifyTasksConfirmOwner;
    private boolean notifyTasksConfirmParticipant;
    private boolean msgPreview;
    private boolean ignoreOriginalMailTextOnReply;
    private boolean noCopyIntoStandardSentFolder;
    private boolean spamEnabled;
    private boolean textOnlyCompose;
    private boolean allowHTMLImages;
    private boolean replyAllCc;
    private Signature[] signatures;
    private String sendAddr;
    private String replyToAddr;
    private int msgFormat = 1;
    private String[] displayMsgHeaders;
    private int autoLinebreak = 80;
    private String stdTrashName;
    private String stdDraftsName;
    private String stdSentName;
    private String stdSpamName;
    private String confirmedSpam;
    private String confirmedHam;
    private long uploadQuota;
    private long uploadQuotaPerFile;
    private Boolean spamHandlerFound;
    private boolean noSave;
    private boolean dropReplyForwardPrefix;
    private int attachOriginalMessage;

    public UserSettingMail(int userId, int cid) {
        this.userId = userId;
        this.cid = cid;
        this.attachOriginalMessage = -1;
    }

    public Object clone() {
        try {
            UserSettingMail clone = (UserSettingMail)super.clone();
            if (this.displayMsgHeaders != null) {
                clone.displayMsgHeaders = new String[this.displayMsgHeaders.length];
                System.arraycopy(this.displayMsgHeaders, 0, clone.displayMsgHeaders, 0, this.displayMsgHeaders.length);
            }
            if (this.signatures != null) {
                clone.signatures = new Signature[this.signatures.length];
                for (int i = 0; i < this.signatures.length; ++i) {
                    clone.signatures[i] = (Signature)this.signatures[i].clone();
                }
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            InternalError error = new InternalError(e.getMessage());
            error.initCause(e);
            throw error;
        }
    }

    public int getAutoLinebreak() {
        return this.autoLinebreak;
    }

    public boolean isDropReplyForwardPrefix() {
        return this.dropReplyForwardPrefix;
    }

    public void setDropReplyForwardPrefix(boolean dropReplyForwardPrefix) {
        this.dropReplyForwardPrefix = dropReplyForwardPrefix;
    }

    public int getBitsValue() {
        int retval = 0;
        retval = this.displayHtmlInlineContent ? retval | 1 : retval;
        retval = this.useColorQuote ? retval | 2 : retval;
        retval = this.showGraphicEmoticons ? retval | 4 : retval;
        retval = this.hardDeleteMsgs ? retval | 8 : retval;
        retval = this.forwardAsAttachment ? retval | 0x10 : retval;
        retval = this.appendVCard ? retval | 0x20 : retval;
        retval = this.notifyOnReadAck ? retval | 0x40 : retval;
        retval = this.msgPreview ? retval | 0x80 : retval;
        retval = this.notifyAppointments ? retval | 0x100 : retval;
        retval = this.notifyAppointmentsConfirmOwner ? retval | 0x8000 : retval;
        retval = this.notifyAppointmentsConfirmParticipant ? retval | 0x10000 : retval;
        retval = this.notifyTasks ? retval | 0x200 : retval;
        retval = this.notifyTasksConfirmOwner ? retval | 0x20000 : retval;
        retval = this.notifyTasksConfirmParticipant ? retval | 0x40000 : retval;
        retval = this.ignoreOriginalMailTextOnReply ? retval | 0x400 : retval;
        retval = this.noCopyIntoStandardSentFolder ? retval | 0x800 : retval;
        retval = this.spamEnabled ? retval | 0x1000 : retval;
        retval = this.textOnlyCompose ? retval | 0x2000 : retval;
        retval = this.allowHTMLImages ? retval | 0x4000 : retval;
        retval = this.replyAllCc ? retval | 0x80000 : retval;
        return retval;
    }

    public String getConfirmedHam() {
        return this.confirmedHam;
    }

    public String getConfirmedSpam() {
        return this.confirmedSpam;
    }

    public String[] getDisplayMsgHeaders() {
        if (this.displayMsgHeaders == null) {
            return null;
        }
        String[] retval = new String[this.displayMsgHeaders.length];
        System.arraycopy(this.displayMsgHeaders, 0, retval, 0, this.displayMsgHeaders.length);
        return retval;
    }

    public int getMsgFormat() {
        return this.msgFormat;
    }

    public String getReplyToAddr() {
        return this.replyToAddr;
    }

    public String getSendAddr() {
        return this.sendAddr;
    }

    public Signature[] getSignatures() {
        if (this.signatures == null) {
            return null;
        }
        Signature[] retval = new Signature[this.signatures.length];
        System.arraycopy(this.signatures, 0, retval, 0, this.signatures.length);
        return retval;
    }

    public String getStdDraftsName() {
        return this.stdDraftsName;
    }

    public String getStdSentName() {
        return this.stdSentName;
    }

    public String getStdSpamName() {
        return this.stdSpamName;
    }

    public String getStdTrashName() {
        return this.stdTrashName;
    }

    public long getUploadQuota() {
        return this.uploadQuota;
    }

    public long getUploadQuotaPerFile() {
        return this.uploadQuotaPerFile;
    }

    public boolean isAppendVCard() {
        return this.appendVCard;
    }

    public boolean isDisplayHtmlInlineContent() {
        return this.displayHtmlInlineContent;
    }

    public boolean isSuppressHTMLAlternativePart() {
        return this.suppressHTMLAlternativePart;
    }

    public boolean isForwardAsAttachment() {
        return this.forwardAsAttachment || this.attachOriginalMessage > 0;
    }

    public int getAttachOriginalMessage() {
        return this.attachOriginalMessage;
    }

    public boolean isHardDeleteMsgs() {
        return this.hardDeleteMsgs;
    }

    public boolean isIgnoreOriginalMailTextOnReply() {
        return this.ignoreOriginalMailTextOnReply;
    }

    public boolean isModifiedDuringSession() {
        return this.modifiedDuringSession;
    }

    public boolean isMsgPreview() {
        return this.msgPreview;
    }

    public boolean isNoCopyIntoStandardSentFolder() {
        return this.noCopyIntoStandardSentFolder;
    }

    public boolean isNotifyAppointments() {
        return this.notifyAppointments;
    }

    public boolean isNotifyAppointmentsConfirmOwner() {
        return this.notifyAppointmentsConfirmOwner;
    }

    public boolean isNotifyAppointmentsConfirmParticipant() {
        return this.notifyAppointmentsConfirmParticipant;
    }

    public boolean isNotifyTasksConfirmOwner() {
        return this.notifyTasksConfirmOwner;
    }

    public boolean isNotifyTasksConfirmParticipant() {
        return this.notifyTasksConfirmParticipant;
    }

    public boolean isNotifyOnReadAck() {
        return this.notifyOnReadAck;
    }

    public boolean isNotifyTasks() {
        return this.notifyTasks;
    }

    public boolean isShowGraphicEmoticons() {
        return this.showGraphicEmoticons;
    }

    public boolean isSpamEnabled() {
        if (null == this.spamHandlerFound) {
            try {
                MailAccountStorageService storage = ServerServiceRegistry.getInstance().getService(MailAccountStorageService.class, true);
                this.spamHandlerFound = SpamHandlerRegistry.hasSpamHandler(storage.getDefaultMailAccount(this.userId, this.cid));
            }
            catch (OXException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return null != this.spamHandlerFound && this.spamHandlerFound != false && this.spamEnabled;
    }

    public boolean isSpamOptionEnabled() {
        return this.spamEnabled;
    }

    public boolean isTextOnlyCompose() {
        return this.textOnlyCompose;
    }

    public boolean isAllowHTMLImages() {
        return this.allowHTMLImages;
    }

    public boolean isReplyAllCc() {
        return this.replyAllCc;
    }

    public boolean isUseColorQuote() {
        return this.useColorQuote;
    }

    public boolean isNoSave() {
        return this.noSave;
    }

    public void parseBits(int onOffOptions) {
        this.displayHtmlInlineContent = (onOffOptions & 1) == 1;
        this.useColorQuote = (onOffOptions & 2) == 2;
        this.showGraphicEmoticons = (onOffOptions & 4) == 4;
        this.hardDeleteMsgs = (onOffOptions & 8) == 8;
        this.forwardAsAttachment = (onOffOptions & 0x10) == 16;
        this.appendVCard = (onOffOptions & 0x20) == 32;
        this.notifyOnReadAck = (onOffOptions & 0x40) == 64;
        this.msgPreview = (onOffOptions & 0x80) == 128;
        this.notifyAppointments = (onOffOptions & 0x100) == 256;
        this.notifyAppointmentsConfirmOwner = (onOffOptions & 0x8000) == 32768;
        this.notifyAppointmentsConfirmParticipant = (onOffOptions & 0x10000) == 65536;
        this.notifyTasks = (onOffOptions & 0x200) == 512;
        this.notifyTasksConfirmOwner = (onOffOptions & 0x20000) == 131072;
        this.notifyTasksConfirmParticipant = (onOffOptions & 0x40000) == 262144;
        this.ignoreOriginalMailTextOnReply = (onOffOptions & 0x400) == 1024;
        this.noCopyIntoStandardSentFolder = (onOffOptions & 0x800) == 2048;
        this.spamEnabled = (onOffOptions & 0x1000) == 4096;
        this.textOnlyCompose = (onOffOptions & 0x2000) == 8192;
        this.allowHTMLImages = (onOffOptions & 0x4000) == 16384;
        this.replyAllCc = (onOffOptions & 0x80000) == 524288;
    }

    public void setAppendVCard(boolean appendVCard) {
        this.appendVCard = appendVCard;
        this.modifiedDuringSession = true;
    }

    public void setAutoLinebreak(int autoLineBreak) {
        this.autoLinebreak = autoLineBreak >= 0 ? autoLineBreak : 0;
        this.modifiedDuringSession = true;
    }

    public void setConfirmedHam(String confirmedHam) {
        this.confirmedHam = confirmedHam;
    }

    public void setConfirmedSpam(String confirmedSpam) {
        this.confirmedSpam = confirmedSpam;
    }

    public void setDisplayHtmlInlineContent(boolean htmlPreview) {
        this.displayHtmlInlineContent = htmlPreview;
        this.modifiedDuringSession = true;
    }

    public void setSuppressHTMLAlternativePart(boolean suppressHTMLAlternativePart) {
        this.suppressHTMLAlternativePart = suppressHTMLAlternativePart;
    }

    public void setDisplayMsgHeaders(String[] displayMsgHeaders) {
        if (displayMsgHeaders == null) {
            this.displayMsgHeaders = null;
            this.modifiedDuringSession = true;
            return;
        }
        this.displayMsgHeaders = new String[displayMsgHeaders.length];
        System.arraycopy(displayMsgHeaders, 0, this.displayMsgHeaders, 0, displayMsgHeaders.length);
        this.modifiedDuringSession = true;
    }

    public void setForwardAsAttachment(boolean forwardAsAttachment) {
        this.forwardAsAttachment = forwardAsAttachment;
        this.modifiedDuringSession = true;
    }

    public void setAttachOriginalMessage(boolean attachOriginalMessage) {
        this.attachOriginalMessage = attachOriginalMessage ? 1 : 0;
        this.modifiedDuringSession = true;
    }

    public void setHardDeleteMsgs(boolean hardDeleteMessages) {
        this.hardDeleteMsgs = hardDeleteMessages;
        this.modifiedDuringSession = true;
    }

    public void setIgnoreOriginalMailTextOnReply(boolean appendOriginalMailTextToReply) {
        this.ignoreOriginalMailTextOnReply = appendOriginalMailTextToReply;
        this.modifiedDuringSession = true;
    }

    void setModifiedDuringSession(boolean modifiedDuringSession) {
        this.modifiedDuringSession = modifiedDuringSession;
    }

    public void setMsgFormat(int msgFormat) {
        this.msgFormat = msgFormat;
        this.modifiedDuringSession = true;
    }

    public void setMsgPreview(boolean msgPreview) {
        this.msgPreview = msgPreview;
        this.modifiedDuringSession = true;
    }

    public void setNoCopyIntoStandardSentFolder(boolean noCopyIntoStandardSentFolder) {
        this.noCopyIntoStandardSentFolder = noCopyIntoStandardSentFolder;
        this.modifiedDuringSession = true;
    }

    public void setNotifyAppointments(boolean notifyAppointments) {
        this.notifyAppointments = notifyAppointments;
        this.modifiedDuringSession = true;
    }

    public void setNotifyOnReadAck(boolean notifyOnReadAck) {
        this.notifyOnReadAck = notifyOnReadAck;
        this.modifiedDuringSession = true;
    }

    public void setNotifyTasks(boolean notifyTasks) {
        this.notifyTasks = notifyTasks;
        this.modifiedDuringSession = true;
    }

    public void setReplyToAddr(String replyToAddr) {
        this.replyToAddr = IDNA.toIDN((String)replyToAddr);
        this.modifiedDuringSession = true;
    }

    public void setSendAddr(String sendAddr) {
        this.sendAddr = IDNA.toIDN((String)sendAddr);
        this.modifiedDuringSession = true;
    }

    public void setShowGraphicEmoticons(boolean showGraphicEmoticons) {
        this.showGraphicEmoticons = showGraphicEmoticons;
        this.modifiedDuringSession = true;
    }

    public void setSignatures(Signature[] signatures) {
        if (signatures == null) {
            this.signatures = null;
            this.modifiedDuringSession = true;
            return;
        }
        this.signatures = new Signature[signatures.length];
        System.arraycopy(signatures, 0, this.signatures, 0, signatures.length);
        this.modifiedDuringSession = true;
    }

    public void setSpamEnabled(boolean spamEnabled) {
        this.spamEnabled = spamEnabled;
        this.modifiedDuringSession = true;
    }

    public void setStdDraftsName(String stdDraftsName) {
        this.stdDraftsName = stdDraftsName;
        this.modifiedDuringSession = true;
    }

    public void setStdSentName(String stdSentName) {
        this.stdSentName = stdSentName;
        this.modifiedDuringSession = true;
    }

    public void setStdSpamName(String stdSpamName) {
        this.stdSpamName = stdSpamName;
        this.modifiedDuringSession = true;
    }

    public void setStdTrashName(String stdTrashName) {
        this.stdTrashName = stdTrashName;
        this.modifiedDuringSession = true;
    }

    public void setTextOnlyCompose(boolean textOnlyCompose) {
        this.textOnlyCompose = textOnlyCompose;
        this.modifiedDuringSession = true;
    }

    public void setAllowHTMLImages(boolean allowHTMLImages) {
        this.allowHTMLImages = allowHTMLImages;
        this.modifiedDuringSession = true;
    }

    public void setReplyAllCc(boolean replyAllCc) {
        this.replyAllCc = replyAllCc;
    }

    public void setUploadQuota(long uploadQuota) {
        this.uploadQuota = uploadQuota;
        this.modifiedDuringSession = true;
    }

    public void setUploadQuotaPerFile(long uploadQuotaPerFile) {
        this.uploadQuotaPerFile = uploadQuotaPerFile;
        this.modifiedDuringSession = true;
    }

    public void setUseColorQuote(boolean useColorQuote) {
        this.useColorQuote = useColorQuote;
        this.modifiedDuringSession = true;
    }

    public void setNotifyAppointmentsConfirmOwner(boolean notifyAppointmentsConfirmOwner) {
        this.notifyAppointmentsConfirmOwner = notifyAppointmentsConfirmOwner;
        this.modifiedDuringSession = true;
    }

    public void setNotifyAppointmentsConfirmParticipant(boolean notifyAppointmentsConfirmParticipant) {
        this.notifyAppointmentsConfirmParticipant = notifyAppointmentsConfirmParticipant;
        this.modifiedDuringSession = true;
    }

    public void setNotifyTasksConfirmOwner(boolean notifyTasksConfirmOwner) {
        this.notifyTasksConfirmOwner = notifyTasksConfirmOwner;
        this.modifiedDuringSession = true;
    }

    public void setNotifyTasksConfirmParticipant(boolean notifyTasksConfirmParticipant) {
        this.notifyTasksConfirmParticipant = notifyTasksConfirmParticipant;
        this.modifiedDuringSession = true;
    }

    public void setNoSave(boolean noSave) {
        this.noSave = noSave;
    }

    public int getUserId() {
        return this.userId;
    }

    public int getCid() {
        return this.cid;
    }

    public static final class Signature
    implements Cloneable,
    Serializable {
        private static final long serialVersionUID = 357223875887317509L;
        private String id;
        private String signature;

        public Signature(String id, String signature) {
            this.id = id;
            this.signature = signature;
        }

        public Object clone() {
            try {
                Signature clone = (Signature)super.clone();
                clone.id = this.id;
                clone.signature = this.signature;
                return clone;
            }
            catch (CloneNotSupportedException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
                InternalError error = new InternalError(e.getMessage());
                error.initCause(e);
                throw error;
            }
        }

        public String getId() {
            return this.id;
        }

        public String getSignature() {
            return this.signature;
        }
    }
}

