/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.search;

import com.openexchange.exception.OXException;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.mail.MailField;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.search.ComparablePattern;
import com.openexchange.mail.search.ComparisonType;
import com.openexchange.mail.search.SearchTerm;
import com.openexchange.mail.search.SearchTermVisitor;
import java.util.Collection;
import javax.mail.Message;
import javax.mail.MessagingException;

public final class SizeTerm
extends SearchTerm<ComparablePattern<Integer>> {
    private static final long serialVersionUID = 6011159685554702125L;
    private final ComparablePattern<Integer> pattern;

    public SizeTerm(final ComparisonType comparisonType, final int size) {
        this.pattern = new ComparablePattern<Integer>(){
            private final Integer i;
            {
                this.i = size;
            }

            @Override
            public ComparisonType getComparisonType() {
                return comparisonType;
            }

            @Override
            public Integer getPattern() {
                return this.i;
            }
        };
    }

    @Override
    public void accept(SearchTermVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public ComparablePattern<Integer> getPattern() {
        return this.pattern;
    }

    @Override
    public void addMailField(Collection<MailField> col) {
        col.add(MailField.SIZE);
    }

    @Override
    public boolean matches(Message msg) throws OXException {
        int size;
        try {
            size = msg.getSize();
        }
        catch (MessagingException e) {
            Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(SizeTerm.class)).warn((Object)"Error during search.", (Throwable)e);
            return false;
        }
        Object pattern = this.getPattern();
        ComparisonType comparisonType = pattern.getComparisonType();
        if (ComparisonType.EQUALS == comparisonType) {
            return size == (Integer)pattern.getPattern();
        }
        if (ComparisonType.LESS_THAN == comparisonType) {
            return size < (Integer)pattern.getPattern();
        }
        if (ComparisonType.GREATER_THAN == comparisonType) {
            return size > (Integer)pattern.getPattern();
        }
        return size == (Integer)pattern.getPattern();
    }

    @Override
    public boolean matches(MailMessage mailMessage) {
        long size = mailMessage.getSize();
        Object pattern = this.getPattern();
        ComparisonType comparisonType = pattern.getComparisonType();
        if (ComparisonType.EQUALS == comparisonType) {
            return size == (long)((Integer)pattern.getPattern()).intValue();
        }
        if (ComparisonType.LESS_THAN == comparisonType) {
            return size < (long)((Integer)pattern.getPattern()).intValue();
        }
        if (ComparisonType.GREATER_THAN == comparisonType) {
            return size > (long)((Integer)pattern.getPattern()).intValue();
        }
        return size == (long)((Integer)pattern.getPattern()).intValue();
    }

    @Override
    public javax.mail.search.SearchTerm getJavaMailSearchTerm() {
        Object pattern = this.getPattern();
        return new javax.mail.search.SizeTerm(pattern.getComparisonType().getType(), ((Integer)pattern.getPattern()).intValue());
    }

    @Override
    public javax.mail.search.SearchTerm getNonWildcardJavaMailSearchTerm() {
        return this.getJavaMailSearchTerm();
    }
}

