/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.parser.handlers;

import com.openexchange.exception.OXException;
import com.openexchange.log.LogFactory;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.config.MailProperties;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.dataobjects.MailPart;
import com.openexchange.mail.dataobjects.UUEncodedAttachmentMailPart;
import com.openexchange.mail.mime.ContentType;
import com.openexchange.mail.mime.MimeDefaultSession;
import com.openexchange.mail.mime.MimeMailException;
import com.openexchange.mail.mime.MimeType2ExtMap;
import com.openexchange.mail.mime.converters.MimeMessageConverter;
import com.openexchange.mail.mime.datasource.MessageDataSource;
import com.openexchange.mail.parser.MailMessageHandler;
import com.openexchange.mail.parser.MailMessageParser;
import com.openexchange.mail.uuencode.UUEncodedPart;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.MessagingException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.apache.commons.logging.Log;

public final class MailPartHandler
implements MailMessageHandler {
    private static final Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(MailPartHandler.class));
    private String id;
    private MailPart mailPart;

    public MailPartHandler(String id) {
        this.id = id;
    }

    public void setSequenceId(String id) {
        this.id = id;
        this.mailPart = null;
    }

    @Override
    public boolean handleMultipartEnd(MailPart mp, String id) throws OXException {
        return true;
    }

    @Override
    public boolean handleAttachment(MailPart part, boolean isInline, String baseContentType, String fileName, String id) throws OXException {
        if (this.id.equals(id)) {
            this.mailPart = part;
            if (!isInline) {
                MailPartHandler.checkFilename(this.mailPart, id, baseContentType);
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean handleBccRecipient(InternetAddress[] recipientAddrs) throws OXException {
        return true;
    }

    @Override
    public boolean handleCcRecipient(InternetAddress[] recipientAddrs) throws OXException {
        return true;
    }

    @Override
    public boolean handleColorLabel(int colorLabel) throws OXException {
        return true;
    }

    @Override
    public boolean handleContentId(String contentId) throws OXException {
        return true;
    }

    @Override
    public boolean handleFrom(InternetAddress[] fromAddrs) throws OXException {
        return true;
    }

    @Override
    public boolean handleHeaders(int size, Iterator<Map.Entry<String, String>> iter) throws OXException {
        return true;
    }

    @Override
    public boolean handleImagePart(MailPart part, String imageCID, String baseContentType, boolean isInline, String fileName, String id) throws OXException {
        if (this.id.equals(id)) {
            this.mailPart = part;
            MailPartHandler.checkFilename(this.mailPart, id, baseContentType);
            return false;
        }
        return true;
    }

    @Override
    public boolean handleInlineHtml(String htmlContent, ContentType contentType, long size, String fileName, String id) throws OXException {
        if (this.id.equals(id)) {
            this.mailPart = new TextMailPart(htmlContent, contentType);
            this.mailPart.setContentType(contentType);
            this.mailPart.setSize(size);
            this.mailPart.setFileName(fileName);
            this.mailPart.setSequenceId(id);
            return false;
        }
        return true;
    }

    @Override
    public boolean handleInlinePlainText(String plainTextContent, ContentType contentType, long size, String fileName, String id) throws OXException {
        if (this.id.equals(id)) {
            this.mailPart = new TextMailPart(plainTextContent, contentType);
            this.mailPart.setContentType(contentType);
            this.mailPart.setSize(size);
            this.mailPart.setFileName(fileName);
            this.mailPart.setSequenceId(id);
            return false;
        }
        return true;
    }

    @Override
    public boolean handleInlineUUEncodedAttachment(UUEncodedPart part, String id) throws OXException {
        if (this.id.equals(id)) {
            this.mailPart = new UUEncodedAttachmentMailPart(part);
            String ct = MimeType2ExtMap.getContentType(part.getFileName());
            if (ct == null || ct.length() == 0) {
                ct = "application/octet-stream";
            }
            this.mailPart.setContentType(ct);
            this.mailPart.setSize(part.getFileSize());
            this.mailPart.setFileName(part.getFileName());
            this.mailPart.setSequenceId(id);
            return false;
        }
        return true;
    }

    @Override
    public boolean handleInlineUUEncodedPlainText(String decodedTextContent, ContentType contentType, int size, String fileName, String id) throws OXException {
        return this.handleInlinePlainText(decodedTextContent, contentType, size, fileName, id);
    }

    @Override
    public void handleMessageEnd(MailMessage msg) throws OXException {
    }

    @Override
    public boolean handleMultipart(MailPart mp, int bodyPartCount, String id) throws OXException {
        return true;
    }

    @Override
    public boolean handleNestedMessage(MailPart mailPart, String id) throws OXException {
        MailMessage nestedMail;
        if (this.id.equals(id)) {
            this.mailPart = mailPart;
            return false;
        }
        Object content = mailPart.getContent();
        if (content instanceof MailMessage) {
            nestedMail = (MailMessage)content;
        } else if (content instanceof InputStream) {
            try {
                nestedMail = MimeMessageConverter.convertMessage(new MimeMessage(MimeDefaultSession.getDefaultSession(), (InputStream)content));
            }
            catch (MessagingException e) {
                throw MimeMailException.handleMessagingException(e);
            }
        } else {
            LOG.error((Object)("Ignoring nested message. Cannot handle part's content which should be a RFC822 message according to its content type: " + (null == content ? "null" : content.getClass().getSimpleName())));
            return true;
        }
        MailPartHandler nestedHandler = new MailPartHandler(this.id);
        new MailMessageParser().parseMailMessage(nestedMail, nestedHandler, id);
        if (null != nestedHandler.getMailPart()) {
            this.mailPart = nestedHandler.getMailPart();
            return false;
        }
        return true;
    }

    @Override
    public boolean handlePriority(int priority) throws OXException {
        return true;
    }

    @Override
    public boolean handleMsgRef(String msgRef) throws OXException {
        return true;
    }

    @Override
    public boolean handleDispositionNotification(InternetAddress dispositionNotificationTo, boolean seen) throws OXException {
        return true;
    }

    @Override
    public boolean handleReceivedDate(Date receivedDate) throws OXException {
        return true;
    }

    @Override
    public boolean handleSentDate(Date sentDate) throws OXException {
        return true;
    }

    @Override
    public boolean handleSpecialPart(MailPart part, String baseContentType, String fileName, String id) throws OXException {
        return this.handleAttachment(part, !"attachment".equalsIgnoreCase(part.getContentDisposition().getDisposition()) && part.getFileName() == null, baseContentType, fileName, id);
    }

    @Override
    public boolean handleSubject(String subject) throws OXException {
        return true;
    }

    @Override
    public boolean handleSystemFlags(int flags) throws OXException {
        return true;
    }

    @Override
    public boolean handleToRecipient(InternetAddress[] recipientAddrs) throws OXException {
        return true;
    }

    @Override
    public boolean handleUserFlags(String[] userFlags) throws OXException {
        return true;
    }

    public MailPart getMailPart() {
        return this.mailPart;
    }

    private static void checkFilename(MailPart mailPart, String id, String baseMimeType) {
        if (mailPart.getFileName() == null) {
            mailPart.setFileName(MailMessageParser.generateFilename(id, baseMimeType));
        }
    }

    private static final class TextMailPart
    extends MailPart {
        private static final long serialVersionUID = 5622318721711740585L;
        private final String text;
        private transient DataSource dataSource;

        public TextMailPart(String text, ContentType contentType) {
            this.text = text;
            this.setSize(text.length());
            if (contentType.getCharsetParameter() == null) {
                contentType.setCharsetParameter(MailProperties.getInstance().getDefaultMimeCharset());
            }
            this.setContentType(contentType);
        }

        private DataSource getDataSource() throws OXException {
            if (null == this.dataSource) {
                try {
                    this.dataSource = new MessageDataSource(this.text, this.getContentType());
                }
                catch (UnsupportedEncodingException e) {
                    throw MailExceptionCode.IO_ERROR.create(e, e.getMessage());
                }
            }
            return this.dataSource;
        }

        @Override
        public Object getContent() throws OXException {
            return this.text;
        }

        @Override
        public DataHandler getDataHandler() throws OXException {
            return new DataHandler(this.getDataSource());
        }

        @Override
        public int getEnclosedCount() throws OXException {
            return -1;
        }

        @Override
        public MailPart getEnclosedMailPart(int index) throws OXException {
            return null;
        }

        @Override
        public InputStream getInputStream() throws OXException {
            try {
                return this.getDataSource().getInputStream();
            }
            catch (IOException e) {
                if ("com.sun.mail.util.MessageRemovedIOException".equals(e.getClass().getName())) {
                    throw MailExceptionCode.MAIL_NOT_FOUND_SIMPLE.create(e, new Object[0]);
                }
                throw MailExceptionCode.IO_ERROR.create(e, e.getMessage());
            }
        }

        @Override
        public void loadContent() {
        }

        @Override
        public void prepareForCaching() {
        }
    }
}

