/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.mime.utils;

import com.openexchange.ajax.requesthandler.DefaultDispatcherPrefixService;
import com.openexchange.dispatcher.DispatcherPrefixService;
import com.openexchange.java.Strings;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class ImageMatcher {
    private static final String DEFAULT_ALT_PREFIX = "/ox7/api/";
    private static final int GROUP_FILE_ID = 5;
    private static final int GROUP_IMG_ID = 13;
    private static volatile Pattern PATTERN_REF_IMG = null;
    private final Matcher matcher;

    public static ImageMatcher matcher(CharSequence content) {
        return new ImageMatcher(content);
    }

    public static void setPrefixService(DispatcherPrefixService prefixService) {
        if (null == prefixService) {
            PATTERN_REF_IMG = null;
        } else {
            String altPrefix;
            String prefix = DefaultDispatcherPrefixService.getInstance().getPrefix();
            if (prefix.charAt(0) == '/') {
                prefix = prefix.substring(1);
            }
            if (!(altPrefix = DEFAULT_ALT_PREFIX.substring(1)).equalsIgnoreCase(prefix)) {
                prefix = "(?:" + prefix + "|" + altPrefix + ")";
            }
            String regexImageUrl = "(<img[^>]*?)(src=\")(?:[^>]*?)" + prefix + "image" + "([^\"]+?)(?:\\?|&amp;|&)(uid=)([^\"&]+)(?:(&[^\"]+\")|(\"))([^>]*/?>)";
            String regexFileUrl = "(<img[^>]*?)(src=\")(?:[^>]*?)" + prefix + "file([^\"]+?)(?:\\?|&amp;|&)(id=)([^\"&]+)(?:(&[^\"]+\")|(\"))([^>]*/?>)";
            PATTERN_REF_IMG = Pattern.compile("(?:" + regexFileUrl + ")|(?:" + regexImageUrl + ')', 34);
        }
    }

    private ImageMatcher(CharSequence content) {
        Pattern pattern = PATTERN_REF_IMG;
        if (null == pattern) {
            throw new IllegalStateException(ImageMatcher.class.getSimpleName() + " not initialized, yet.");
        }
        this.matcher = pattern.matcher(content);
    }

    public String group() {
        return this.matcher.group();
    }

    public String group(int group) {
        return this.matcher.group(group);
    }

    public int groupCount() {
        return this.matcher.groupCount();
    }

    public boolean matches() {
        return this.matcher.matches();
    }

    public boolean find() {
        return this.matcher.find();
    }

    public String getManagedFileId() {
        return this.matcher.group(5);
    }

    public String getImageId() {
        return this.matcher.group(13);
    }

    public int start() {
        return this.matcher.start();
    }

    public int end() {
        return this.matcher.end();
    }

    public Matcher appendReplacement(StringBuffer sb, String replacement) {
        return this.matcher.appendReplacement(sb, replacement);
    }

    public Matcher appendLiteralReplacement(StringBuffer sb, String replacement) {
        return this.matcher.appendReplacement(sb, Strings.quoteReplacement((String)replacement));
    }

    public StringBuffer appendTail(StringBuffer sb) {
        return this.matcher.appendTail(sb);
    }
}

