/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.mime.processing;

import com.openexchange.exception.OXException;
import com.openexchange.html.HtmlService;
import com.openexchange.java.CharsetDetector;
import com.openexchange.java.StringAllocator;
import com.openexchange.java.Strings;
import com.openexchange.log.LogFactory;
import com.openexchange.mail.api.IMailFolderStorage;
import com.openexchange.mail.api.IMailMessageStorage;
import com.openexchange.mail.api.MailAccess;
import com.openexchange.mail.config.MailProperties;
import com.openexchange.mail.dataobjects.MailFolder;
import com.openexchange.mail.dataobjects.MailPart;
import com.openexchange.mail.mime.ContentDisposition;
import com.openexchange.mail.mime.ContentType;
import com.openexchange.mail.mime.QuotedInternetAddress;
import com.openexchange.mail.mime.utils.MimeMessageUtility;
import com.openexchange.mail.text.HtmlProcessing;
import com.openexchange.mail.utils.MessageUtility;
import com.openexchange.mail.uuencode.UUEncodedMultiPart;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.mail.internet.InternetAddress;
import org.apache.commons.logging.Log;

public final class MimeProcessingUtility {
    private static final Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(MimeProcessingUtility.class));
    private static final String PRIMARY_TEXT = "text/";
    private static final String[] SUB_SPECIAL2 = new String[]{"rfc822-headers", "vcard", "x-vcard", "calendar", "x-vcalendar"};
    private static final String TEXT = "text/";
    private static final String CT_TEXT_HTM = "text/htm";
    private static final String DUMMY_DOMAIN = "@unspecified-domain";

    private MimeProcessingUtility() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final String getFolderOwnerIfShared(String fullName, int accountId, Session session) {
        if (null == fullName) {
            return null;
        }
        MailAccess<IMailFolderStorage, IMailMessageStorage> access = null;
        try {
            access = MailAccess.getInstance(session, accountId);
            access.connect(false);
            MailFolder folder = access.getFolderStorage().getFolder(fullName);
            String string = folder.isShared() ? folder.getOwner() : null;
            return string;
        }
        catch (Exception e) {
            LOG.warn((Object)("Couldn't resolve owner for " + fullName), (Throwable)e);
            String string = null;
            return string;
        }
        finally {
            if (null != access) {
                access.close(true);
            }
        }
    }

    public static final String getFormattedDate(Date date, int style, Locale locale, TimeZone timeZone) {
        DateFormat dateFormat = DateFormat.getDateInstance(style, locale);
        dateFormat.setTimeZone(timeZone);
        return dateFormat.format(date);
    }

    static final String getFormattedTime(Date date, int style, Locale locale, TimeZone timeZone) {
        DateFormat dateFormat = DateFormat.getTimeInstance(style, locale);
        dateFormat.setTimeZone(timeZone);
        return dateFormat.format(date);
    }

    static boolean isInline(MailPart part, ContentType contentType) throws OXException {
        boolean hasDisposition;
        ContentDisposition cd;
        String[] hdr = part.getHeader("Content-Disposition");
        if (null == hdr) {
            cd = new ContentDisposition();
            hasDisposition = false;
        } else {
            cd = new ContentDisposition(hdr[0]);
            hasDisposition = true;
        }
        return hasDisposition && "inline".equalsIgnoreCase(cd.getDisposition()) || !hasDisposition && !cd.containsFilenameParameter() && !contentType.containsParameter("name");
    }

    static boolean fileNameEndsWith(String suffix, MailPart part, ContentType contentType) throws OXException {
        String filename = MimeProcessingUtility.getFileName(part, contentType);
        return null == filename ? false : filename.toLowerCase(Locale.ENGLISH).endsWith(suffix);
    }

    private static String getFileName(MailPart part, ContentType contentType) throws OXException {
        String[] hdr = part.getHeader("Content-Disposition");
        ContentDisposition cd = null == hdr ? new ContentDisposition() : new ContentDisposition(hdr[0]);
        String filename = cd.getFilenameParameter();
        if (null == filename) {
            filename = contentType.getParameter("name");
        }
        return MimeMessageUtility.decodeMultiEncodedHeader(filename);
    }

    static String handleInlineTextPart(MailPart textPart, ContentType contentType, boolean allowHTML) throws IOException, OXException {
        String charset = MimeProcessingUtility.getCharset(textPart, contentType);
        if (contentType.isMimeType("text/htm*")) {
            if (allowHTML) {
                return MimeProcessingUtility.readContent(textPart, charset);
            }
            contentType.setBaseType("text/plain");
            HtmlService htmlService = ServerServiceRegistry.getInstance().getService(HtmlService.class);
            return htmlService.html2text(MimeProcessingUtility.readContent(textPart, charset), false);
        }
        if (contentType.isMimeType("text/plain")) {
            String content = MimeProcessingUtility.readContent(textPart, charset);
            UUEncodedMultiPart uuencodedMP = new UUEncodedMultiPart(content);
            if (uuencodedMP.isUUEncoded()) {
                return uuencodedMP.getCleanText();
            }
            return content;
        }
        return MimeProcessingUtility.readContent(textPart, charset);
    }

    public static boolean isSpecial(String contentType) {
        if (null == contentType) {
            return false;
        }
        String ct = contentType.toLowerCase(Locale.US);
        if (ct.startsWith("text/", 0)) {
            int off = "text/".length();
            for (String subtype : SUB_SPECIAL2) {
                if (!ct.startsWith(subtype, off)) continue;
                return true;
            }
        }
        return false;
    }

    static String readContent(MailPart mailPart, String charset) throws OXException, IOException {
        try {
            return MessageUtility.readMailPart(mailPart, charset);
        }
        catch (CharConversionException e) {
            String fallback = "US-ASCII";
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)new StringAllocator("Character conversion exception while reading content with charset \"").append(charset).append("\". Using fallback charset \"").append("US-ASCII").append("\" instead."), (Throwable)e);
            }
            return MessageUtility.readMailPart(mailPart, "US-ASCII");
        }
    }

    private static String getCharset(MailPart mailPart, ContentType contentType) throws OXException {
        String charset;
        if (mailPart.containsHeader("Content-Type")) {
            String cs = contentType.getCharsetParameter();
            if (!CharsetDetector.isValid((String)cs)) {
                if (null != cs) {
                    LOG.warn((Object)("Illegal or unsupported encoding in a message detected: \"" + cs + '\"'), (Throwable)new UnsupportedEncodingException(cs));
                }
                cs = contentType.startsWith("text/") ? CharsetDetector.detectCharset((InputStream)mailPart.getInputStream()) : MailProperties.getInstance().getDefaultMimeCharset();
            }
            charset = cs;
        } else {
            charset = contentType.startsWith("text/") ? CharsetDetector.detectCharset((InputStream)mailPart.getInputStream()) : MailProperties.getInstance().getDefaultMimeCharset();
        }
        return charset;
    }

    public static String addrs2String(InternetAddress[] addrs) {
        StringAllocator tmp = new StringAllocator(addrs.length << 4);
        boolean first = true;
        for (int i = 0; i < addrs.length; ++i) {
            String string = MimeProcessingUtility.addr2String(addrs[i]);
            if (MimeProcessingUtility.isEmpty(string)) continue;
            if (first) {
                first = false;
            } else {
                tmp.append(", ");
            }
            tmp.append(string);
        }
        return first ? "" : tmp.toString();
    }

    static String addr2String(InternetAddress addr) {
        int pos;
        if (null == addr) {
            return "";
        }
        String sAddress = addr.getAddress();
        int n = pos = null == sAddress ? 0 : sAddress.indexOf(47);
        if (pos <= 0) {
            return addr.toUnicodeString();
        }
        StringAllocator sb = new StringAllocator(32);
        String personal = addr.getPersonal();
        if (null == personal) {
            sb.append(MimeProcessingUtility.prepareAddress(sAddress.substring(0, pos)));
        } else {
            sb.append(MimeProcessingUtility.preparePersonal(personal));
            sb.append(" <").append(MimeProcessingUtility.prepareAddress(sAddress.substring(0, pos))).append('>');
        }
        return sb.toString();
    }

    static void appendRightVersion(ContentType rootType, ContentType contentType, String text, StringBuilder textBuilder) {
        if (rootType.getBaseType().equalsIgnoreCase(contentType.getBaseType())) {
            textBuilder.append(text);
        } else if (rootType.startsWith(CT_TEXT_HTM)) {
            textBuilder.append(HtmlProcessing.htmlFormat(text));
        } else {
            textBuilder.append(ServerServiceRegistry.getInstance().getService(HtmlService.class).html2text(text, false));
        }
    }

    static String preparePersonal(String personal) {
        return MimeMessageUtility.quotePhrase(personal, false);
    }

    static String prepareAddress(String address) {
        String decoded = QuotedInternetAddress.toIDN(MimeMessageUtility.decodeMultiEncodedHeader(address));
        int pos = decoded.indexOf(DUMMY_DOMAIN);
        if (pos >= 0) {
            return decoded.substring(0, pos);
        }
        return decoded;
    }

    static boolean isEmpty(String string) {
        if (null == string) {
            return true;
        }
        int len = string.length();
        boolean isWhitespace = true;
        for (int i = 0; isWhitespace && i < len; ++i) {
            isWhitespace = Strings.isWhitespace((char)string.charAt(i));
        }
        return isWhitespace;
    }
}

