/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.json.actions;

import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.exception.OXException;
import com.openexchange.java.StringAllocator;
import com.openexchange.log.LogFactory;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.MailServletInterface;
import com.openexchange.mail.dataobjects.compose.ComposeType;
import com.openexchange.mail.dataobjects.compose.ComposedMailMessage;
import com.openexchange.mail.json.MailRequest;
import com.openexchange.mail.json.actions.AbstractMailAction;
import com.openexchange.mail.mime.MimeMailException;
import com.openexchange.mail.mime.QuotedInternetAddress;
import com.openexchange.mail.structure.parser.MIMEStructureParser;
import com.openexchange.preferences.ServerUserSetting;
import com.openexchange.server.ServiceLookup;
import com.openexchange.tools.session.ServerSession;
import javax.mail.MessagingException;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.apache.commons.logging.Log;
import org.json.JSONException;
import org.json.JSONObject;

public final class TransportMailAction
extends AbstractMailAction {
    private static final Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(TransportMailAction.class));
    private static final boolean DEBUG = LOG.isDebugEnabled();

    public TransportMailAction(ServiceLookup services) {
        super(services);
    }

    @Override
    protected AJAXRequestResult perform(MailRequest req) throws OXException {
        try {
            int accountId;
            ServerSession session = req.getSession();
            String recipientsStr = req.getParameter("recipients");
            InternetAddress[] recipients = null == recipientsStr ? null : QuotedInternetAddress.parseHeader(recipientsStr, false);
            ComposedMailMessage composedMail = MIMEStructureParser.parseStructure((JSONObject)req.getRequest().requireData(), session);
            if (recipients != null && recipients.length > 0) {
                composedMail.addRecipients(recipients);
            }
            MailServletInterface mailInterface = this.getMailInterface(req);
            try {
                InternetAddress[] fromAddrs = composedMail.getFrom();
                accountId = TransportMailAction.resolveFrom2Account(session, fromAddrs != null && fromAddrs.length > 0 ? fromAddrs[0] : null, true, true);
            }
            catch (OXException e) {
                if (MailExceptionCode.NO_TRANSPORT_SUPPORT.equals(e) || MailExceptionCode.INVALID_SENDER.equals(e)) {
                    throw e;
                }
                LOG.warn((Object)new StringAllocator(128).append(e.getMessage()).append(". Using default account's transport.").toString());
                accountId = 0;
            }
            String id = mailInterface.sendMessage(composedMail, ComposeType.NEW, accountId);
            int pos = id.lastIndexOf(47);
            if (-1 == pos) {
                throw MailExceptionCode.INVALID_MAIL_IDENTIFIER.create(id);
            }
            JSONObject responseObj = new JSONObject();
            responseObj.put("folder_id", (Object)id.substring(0, pos));
            responseObj.put("id", (Object)id.substring(pos + 1));
            try {
                ServerUserSetting setting = ServerUserSetting.getInstance();
                int contextId = session.getContextId();
                int userId = session.getUserId();
                if (setting.isContactCollectOnMailTransport(contextId, userId).booleanValue()) {
                    TransportMailAction.triggerContactCollector(session, composedMail);
                }
            }
            catch (OXException e) {
                LOG.warn((Object)"Contact collector could not be triggered.", (Throwable)e);
            }
            return new AJAXRequestResult((Object)responseObj, "json");
        }
        catch (JSONException e) {
            throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
        }
        catch (RuntimeException e) {
            throw MailExceptionCode.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
        catch (AddressException e) {
            throw MimeMailException.handleMessagingException((MessagingException)((Object)e));
        }
    }
}

