/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.json.actions;

import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.exception.OXException;
import com.openexchange.java.StringAllocator;
import com.openexchange.log.LogFactory;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.MailServletInterface;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.json.MailRequest;
import com.openexchange.mail.json.actions.AbstractMailAction;
import com.openexchange.mail.json.writer.MessageWriter;
import com.openexchange.preferences.ServerUserSetting;
import com.openexchange.server.ServiceLookup;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import com.openexchange.tools.session.ServerSession;
import org.apache.commons.logging.Log;

public final class GetStructureAction
extends AbstractMailAction {
    private static final Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(GetStructureAction.class));

    public GetStructureAction(ServiceLookup services) {
        super(services);
    }

    @Override
    protected AJAXRequestResult perform(MailRequest req) throws OXException {
        try {
            boolean wasUnseen;
            String uid;
            long maxSize;
            ServerSession session = req.getSession();
            AJAXRequestResult data = GetStructureAction.getJSONNullResult();
            String folderPath = req.checkParameter("folder");
            String tmp = req.getParameter("unseen");
            boolean unseen = "1".equals(tmp) || Boolean.parseBoolean(tmp);
            String tmp2 = req.getParameter("max_size");
            if (null == tmp2) {
                maxSize = -1L;
            } else {
                long l = -1L;
                try {
                    l = Long.parseLong(tmp2.trim());
                }
                catch (NumberFormatException e) {
                    l = -1L;
                }
                maxSize = l;
            }
            MailServletInterface mailInterface = this.getMailInterface(req);
            String tmp22 = req.getParameter("id");
            if (null == tmp22) {
                tmp22 = req.getParameter("message_id");
                if (null == tmp22) {
                    throw AjaxExceptionCodes.MISSING_PARAMETER.create("id");
                }
                uid = mailInterface.getMailIDByMessageID(folderPath, tmp22);
            } else {
                uid = tmp22;
            }
            if (GetStructureAction.isEmpty(uid)) {
                throw AjaxExceptionCodes.MISSING_PARAMETER.create("id");
            }
            MailMessage mail = mailInterface.getMessage(folderPath, uid, !unseen);
            if (mail == null) {
                throw MailExceptionCode.MAIL_NOT_FOUND.create(uid, folderPath);
            }
            if (!mail.containsAccountId()) {
                mail.setAccountId(mailInterface.getAccountID());
            }
            boolean bl = unseen ? !mail.isSeen() : (wasUnseen = mail.containsPrevSeen() && !mail.isPrevSeen());
            if (wasUnseen) {
                try {
                    ServerUserSetting setting = ServerUserSetting.getInstance();
                    int contextId = session.getContextId();
                    int userId = session.getUserId();
                    if (setting.isContactCollectOnMailAccess(contextId, userId).booleanValue()) {
                        GetStructureAction.triggerContactCollector(session, mail);
                    }
                }
                catch (OXException e) {
                    LOG.warn((Object)"Contact collector could not be triggered.", (Throwable)e);
                }
            }
            data = new AJAXRequestResult((Object)MessageWriter.writeStructure(mailInterface.getAccountID(), mail, maxSize), "json");
            return data;
        }
        catch (OXException e) {
            if (MailExceptionCode.MAIL_NOT_FOUND.equals(e)) {
                LOG.warn((Object)new StringAllocator("Requested mail could not be found. ").append("Most likely this is caused by concurrent access of multiple clients ").append("while one performed a delete on affected mail.").toString(), (Throwable)e);
                try {
                    String uid;
                    Object[] args = e.getDisplayArgs();
                    String string = uid = null == args || 0 == args.length || null == args[0] ? null : args[0].toString();
                    if ("undefined".equalsIgnoreCase(uid)) {
                        throw MailExceptionCode.PROCESSING_ERROR.create(e, new Object[0]);
                    }
                }
                catch (Exception exception) {}
            } else {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
            throw e;
        }
        catch (RuntimeException e) {
            throw MailExceptionCode.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
    }
}

