/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.json.actions;

import com.openexchange.ajax.requesthandler.AJAXRequestDataTools;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.documentation.RequestMethod;
import com.openexchange.documentation.annotations.Action;
import com.openexchange.documentation.annotations.Parameter;
import com.openexchange.exception.Category;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.i18n.MailStrings;
import com.openexchange.i18n.tools.StringHelper;
import com.openexchange.java.StringAllocator;
import com.openexchange.mail.FullnameArgument;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.api.IMailFolderStorage;
import com.openexchange.mail.api.IMailMessageStorage;
import com.openexchange.mail.api.MailAccess;
import com.openexchange.mail.dataobjects.MailFolderDescription;
import com.openexchange.mail.json.MailRequest;
import com.openexchange.mail.json.actions.AbstractMailAction;
import com.openexchange.mail.permission.DefaultMailPermission;
import com.openexchange.mail.utils.MailFolderUtility;
import com.openexchange.mailaccount.Attribute;
import com.openexchange.mailaccount.MailAccount;
import com.openexchange.mailaccount.MailAccountDescription;
import com.openexchange.mailaccount.MailAccountStorageService;
import com.openexchange.server.ServiceExceptionCode;
import com.openexchange.server.ServiceLookup;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.threadpool.AbstractTask;
import com.openexchange.threadpool.Task;
import com.openexchange.threadpool.ThreadPools;
import com.openexchange.tools.session.ServerSession;
import java.util.EnumSet;
import org.json.JSONArray;
import org.json.JSONException;

@Action(method=RequestMethod.PUT, name="archive", description="Moves mails to archive folder", parameters={@Parameter(name="session", description="A session ID previously obtained from the login module."), @Parameter(name="id", description="Object ID of the requested mail."), @Parameter(name="folder", description="Object ID of the source folder.")}, requestBody="A JSON object containing the id of the destination folder inside the \"folder_id\" field: e.g.: {\"folder_id\": 1376}.", responseDescription="A JSON array containing the ID of the copied mail.")
public final class ArchiveAction
extends AbstractMailAction {
    public ArchiveAction(ServiceLookup services) {
        super(services);
    }

    @Override
    protected AJAXRequestResult perform(MailRequest req) throws OXException {
        MailAccess<IMailFolderStorage, IMailMessageStorage> mailAccess = null;
        try {
            String parentFullName;
            String archiveName;
            JSONArray uids = (JSONArray)req.getRequest().getData();
            String sourceFolder = req.checkParameter("folder");
            MailAccountStorageService service = ServerServiceRegistry.getInstance().getService(MailAccountStorageService.class);
            if (null == service) {
                throw ServiceExceptionCode.SERVICE_UNAVAILABLE.create(new Object[]{MailAccountStorageService.class.getName()});
            }
            final ServerSession session = req.getSession();
            FullnameArgument fa = MailFolderUtility.prepareMailFolderParam(sourceFolder);
            final int accountId = fa.getAccountId();
            MailAccount mailAccount = service.getMailAccount(accountId, session.getUserId(), session.getContextId());
            mailAccess = MailAccess.getInstance(session, accountId);
            mailAccess.connect();
            String archiveFullname = mailAccount.getArchiveFullname();
            if (ArchiveAction.isEmpty(archiveFullname)) {
                MailAccountStorageService mass;
                String prefix;
                archiveName = mailAccount.getArchive();
                boolean updateAccount = false;
                if (ArchiveAction.isEmpty(archiveName)) {
                    if (!AJAXRequestDataTools.parseBoolParameter(req.getParameter("useDefaultName"))) {
                        String i18nArchive = StringHelper.valueOf(session.getUser().getLocale()).getString(MailStrings.ARCHIVE);
                        throw MailExceptionCode.MISSING_DEFAULT_FOLDER_NAME.create(Category.CATEGORY_USER_INPUT, new Object[]{i18nArchive});
                    }
                    archiveName = StringHelper.valueOf(session.getUser().getLocale()).getString(MailStrings.DEFAULT_ARCHIVE);
                    updateAccount = true;
                }
                if (ArchiveAction.isEmpty(prefix = mailAccess.getFolderStorage().getDefaultFolderPrefix())) {
                    archiveFullname = archiveName;
                    parentFullName = "default";
                } else {
                    archiveFullname = new StringAllocator(prefix).append(archiveName).toString();
                    parentFullName = prefix.substring(0, prefix.length() - 1);
                }
                if (updateAccount && null != (mass = ServerServiceRegistry.getInstance().getService(MailAccountStorageService.class))) {
                    final String af = archiveFullname;
                    ThreadPools.getThreadPool().submit((Task)new AbstractTask<Void>(){

                        public Void call() throws Exception {
                            MailAccountDescription mad = new MailAccountDescription();
                            mad.setId(accountId);
                            mad.setArchiveFullname(af);
                            mass.updateMailAccount(mad, EnumSet.of(Attribute.ARCHIVE_FULLNAME_LITERAL), session.getUserId(), session.getContextId(), session);
                            return null;
                        }
                    });
                }
            } else {
                char separator = mailAccess.getFolderStorage().getFolder("INBOX").getSeparator();
                int pos = archiveFullname.lastIndexOf(separator);
                if (pos > 0) {
                    parentFullName = archiveFullname.substring(0, pos);
                    archiveName = archiveFullname.substring(pos + 1);
                } else {
                    parentFullName = "default";
                    archiveName = archiveFullname;
                }
            }
            if (!mailAccess.getFolderStorage().exists(archiveFullname)) {
                if (!AJAXRequestDataTools.parseBoolParameter(req.getParameter("createIfAbsent"))) {
                    throw MailExceptionCode.FOLDER_NOT_FOUND.create(archiveFullname);
                }
                MailFolderDescription toCreate = new MailFolderDescription();
                toCreate.setAccountId(accountId);
                toCreate.setParentAccountId(accountId);
                toCreate.setParentFullname(parentFullName);
                toCreate.setExists(false);
                toCreate.setFullname(archiveFullname);
                toCreate.setName(archiveName);
                DefaultMailPermission mp = new DefaultMailPermission();
                mp.setEntity(session.getUserId());
                int p = 128;
                mp.setAllPermission(128, 128, 128, 128);
                mp.setFolderAdmin(true);
                mp.setGroupPermission(false);
                toCreate.addPermission(mp);
                mailAccess.getFolderStorage().createFolder(toCreate);
            }
            int length = uids.length();
            String[] mailIds = new String[length];
            for (int i = 0; i < length; ++i) {
                mailIds[i] = uids.getString(i);
            }
            mailAccess.getMessageStorage().moveMessages(fa.getFullname(), archiveFullname, mailIds, true);
            AJAXRequestResult aJAXRequestResult = new AJAXRequestResult((Object)Boolean.TRUE, "native");
            return aJAXRequestResult;
        }
        catch (JSONException e) {
            throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
        }
        catch (RuntimeException e) {
            throw MailExceptionCode.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
        finally {
            if (null != mailAccess) {
                mailAccess.close(true);
            }
        }
    }
}

