/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.upload.impl;

import com.openexchange.groupware.upload.UploadFile;
import com.openexchange.java.StringAllocator;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class UploadEvent {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(UploadEvent.class));
    public static final int MAIL_UPLOAD = 1;
    public static final int APPOINTMENT_UPLOAD = 2;
    public static final int TASK_UPLOAD = 3;
    public static final int CONTACT_UPLOAD = 4;
    public static final int DOCUMENT_UPLOAD = 5;
    private int affiliationId = -1;
    private final Map<String, List<UploadFile>> uploadFilesByFieldName = new HashMap<String, List<UploadFile>>();
    private final Map<String, String> formFields = new HashMap<String, String>();
    private String action;
    private final Map<String, Object> parameters = new HashMap<String, Object>();

    public final int getAffiliationId() {
        return this.affiliationId;
    }

    public final void setAffiliationId(int affiliationId) {
        this.affiliationId = affiliationId;
    }

    public final void addUploadFile(UploadFile uploadFile) {
        if (null != uploadFile) {
            String fieldName = uploadFile.getFieldName();
            List<UploadFile> list = this.uploadFilesByFieldName.get(fieldName);
            if (null == list) {
                list = new LinkedList<UploadFile>();
                this.uploadFilesByFieldName.put(fieldName, list);
            }
            list.add(uploadFile);
        }
    }

    public final UploadFile getUploadFileByFieldName(String fieldName) {
        List<UploadFile> list = this.uploadFilesByFieldName.get(fieldName);
        return null == list || list.isEmpty() ? null : list.get(0);
    }

    public final List<UploadFile> getUploadFilesByFieldName(String fieldName) {
        List<UploadFile> list = this.uploadFilesByFieldName.get(fieldName);
        return null == list ? null : Collections.unmodifiableList(list);
    }

    public final List<UploadFile> getUploadFileByFileName(String fileName) {
        if (null == fileName) {
            return Collections.emptyList();
        }
        LinkedList<UploadFile> ret = new LinkedList<UploadFile>();
        for (List<UploadFile> ufs : this.uploadFilesByFieldName.values()) {
            for (UploadFile uf : ufs) {
                if (!fileName.equals(uf.getFileName())) continue;
                ret.add(uf);
            }
        }
        return ret;
    }

    public final void clearUploadFiles() {
        this.cleanUp();
    }

    public final int getNumberOfUploadFiles() {
        return this.createList().size();
    }

    public final Iterator<UploadFile> getUploadFilesIterator() {
        return this.createList().iterator();
    }

    public final List<UploadFile> getUploadFiles() {
        return this.createList();
    }

    private final List<UploadFile> createList() {
        if (this.uploadFilesByFieldName.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedList<UploadFile> ret = new LinkedList<UploadFile>();
        for (List<UploadFile> ufs : this.uploadFilesByFieldName.values()) {
            ret.addAll(ufs);
        }
        return ret;
    }

    public final void addFormField(String fieldName, String fieldValue) {
        this.formFields.put(fieldName, fieldValue);
    }

    public int getNumberOfFormFields() {
        return this.formFields.size();
    }

    public final String removeFormField(String fieldName) {
        return this.formFields.remove(fieldName);
    }

    public final String getFormField(String fieldName) {
        return this.formFields.get(fieldName);
    }

    public final void clearFormFields() {
        this.formFields.clear();
    }

    public final Iterator<String> getFormFieldNames() {
        return this.formFields.keySet().iterator();
    }

    public final String getAction() {
        return this.action;
    }

    public final void setAction(String action) {
        this.action = action;
    }

    public final Object getParameter(String name) {
        return name == null ? null : this.parameters.get(name);
    }

    public final void setParameter(String name, Object value) {
        if (name != null && value != null) {
            this.parameters.put(name, value);
        }
    }

    public final void removeParameter(String name) {
        if (name != null) {
            this.parameters.remove(name);
        }
    }

    public final void cleanUp() {
        for (List<UploadFile> uploadFiles : this.uploadFilesByFieldName.values()) {
            for (UploadFile uploadFile : uploadFiles) {
                File tmpFile = uploadFile.getTmpFile();
                if (null == tmpFile || !tmpFile.exists()) continue;
                try {
                    if (tmpFile.delete()) continue;
                    LOG.error((Object)new StringAllocator("Temporary upload file could not be deleted: ").append(tmpFile.getName()));
                }
                catch (Exception e) {
                    LOG.error((Object)new StringAllocator("Temporary upload file could not be deleted: ").append(tmpFile.getName()), (Throwable)e);
                }
            }
        }
        this.uploadFilesByFieldName.clear();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Upload event cleaned-up. All temporary stored files deleted.");
        }
    }

    public static final String getFileName(String filePath) {
        String retval = filePath;
        int pos = retval.lastIndexOf(92);
        if (pos > -1) {
            retval = retval.substring(pos + 1);
        } else {
            pos = retval.lastIndexOf(47);
            if (pos > -1) {
                retval = retval.substring(pos + 1);
            }
        }
        return retval;
    }
}

