/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.tasks;

import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.Schema;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTask;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.tools.sql.DBUtils;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public final class SpellCheckUserDictTableTask
implements UpdateTask {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(SpellCheckUserDictTableTask.class));
    private static final String CREATE = "CREATE TABLE spellcheck_user_dict (cid INT4 UNSIGNED NOT NULL,user INT4 UNSIGNED NOT NULL,words TEXT CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL, PRIMARY KEY  (cid, user)) ENGINE = InnoDB";
    private static final String[] types = new String[]{"TABLE"};

    @Override
    public int addedWithVersion() {
        return 13;
    }

    @Override
    public int getPriority() {
        return UpdateTask.UpdateTaskPriority.HIGH.priority;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void perform(Schema schema, int contextId) throws OXException {
        PreparedStatement stmt;
        Connection writeCon;
        block10: {
            writeCon = null;
            stmt = null;
            writeCon = Database.get(contextId, true);
            if (!SpellCheckUserDictTableTask.tableExists("spellcheck_user_dict", writeCon.getMetaData())) break block10;
            DBUtils.closeSQLStuff(null, stmt);
            if (writeCon != null) {
                Database.back(contextId, true, writeCon);
            }
            return;
        }
        try {
            stmt = writeCon.prepareStatement(CREATE);
            stmt.executeUpdate();
            {
                catch (SQLException e) {
                    throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
                }
            }
        }
        catch (Throwable throwable) {
            DBUtils.closeSQLStuff(null, stmt);
            if (writeCon != null) {
                Database.back(contextId, true, writeCon);
            }
            throw throwable;
        }
        DBUtils.closeSQLStuff(null, stmt);
        if (writeCon != null) {
            Database.back(contextId, true, writeCon);
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)"UpdateTask 'SpellCheckUserDictTableTask' performed!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean tableExists(String tableName, DatabaseMetaData dbmd) throws SQLException {
        boolean bl;
        ResultSet resultSet = null;
        try {
            resultSet = dbmd.getTables(null, null, tableName, types);
            bl = resultSet.next();
        }
        catch (Throwable throwable) {
            DBUtils.closeSQLStuff(resultSet, null);
            throw throwable;
        }
        DBUtils.closeSQLStuff(resultSet, null);
        return bl;
    }
}

