/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.tasks;

import com.openexchange.database.DatabaseService;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.PerformParameters;
import com.openexchange.groupware.update.Schema;
import com.openexchange.groupware.update.SchemaStore;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTask;
import com.openexchange.groupware.update.UpdateTaskAdapter;
import com.openexchange.groupware.update.Updater;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.tools.sql.DBUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class LastVersionedUpdateTask
extends UpdateTaskAdapter {
    @Override
    public int addedWithVersion() {
        return 200;
    }

    @Override
    public String[] getDependencies() {
        return new String[0];
    }

    @Override
    public void perform(PerformParameters params) throws OXException {
        Schema schema = params.getSchema();
        List<String> executed = this.determineExecuted(schema.getDBVersion(), Updater.getInstance().getAvailableUpdateTasks());
        int contextId = params.getContextId();
        DatabaseService dbService = ServerServiceRegistry.getInstance().getService(DatabaseService.class, true);
        int poolId = dbService.getWritablePool(contextId);
        Connection con = dbService.getForUpdateTask(contextId);
        try {
            con.setAutoCommit(false);
            executed = this.excludeAlreadyListed(con, executed);
            LastVersionedUpdateTask.insertTasks(con, executed, poolId, schema.getSchema());
            con.commit();
        }
        catch (SQLException e) {
            DBUtils.rollback(con);
            throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
        }
        catch (OXException e) {
            DBUtils.rollback(con);
            throw e;
        }
        finally {
            DBUtils.autocommit(con);
            dbService.backForUpdateTask(contextId, con);
        }
    }

    public static void insertTasks(Connection con, List<String> executed, int poolId, String schema) throws OXException {
        SchemaStore store = SchemaStore.getInstance();
        for (String taskName : executed) {
            store.addExecutedTask(con, taskName, true, poolId, schema);
        }
    }

    private List<String> determineExecuted(int version2, UpdateTask[] tasks2) {
        ArrayList<String> retval = new ArrayList<String>();
        for (UpdateTask task : tasks2) {
            if (task.addedWithVersion() == -1 || task.addedWithVersion() > version2) continue;
            retval.add(task.getClass().getName());
        }
        return retval;
    }

    private List<String> excludeAlreadyListed(Connection con, List<String> executed) throws OXException {
        Statement stmt = null;
        ResultSet result = null;
        try {
            stmt = con.createStatement();
            result = stmt.executeQuery("SELECT taskName FROM updateTask WHERE cid=0");
            while (result.next()) {
                int pos = executed.indexOf(result.getString(1));
                if (pos == -1) continue;
                executed.remove(pos);
            }
        }
        catch (SQLException e) {
            try {
                throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(result, stmt);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(result, stmt);
        return executed;
    }
}

