/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.tasks;

import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.Attributes;
import com.openexchange.groupware.update.PerformParameters;
import com.openexchange.groupware.update.TaskAttributes;
import com.openexchange.groupware.update.UpdateConcurrency;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTaskAdapter;
import com.openexchange.groupware.update.WorkingLevel;
import com.openexchange.log.Log;
import com.openexchange.tools.sql.DBUtils;
import com.openexchange.tools.update.Column;
import com.openexchange.tools.update.Tools;
import java.sql.Connection;
import java.sql.SQLException;

public final class InfostoreExtendFilenameTitleAndFilesizeTask
extends UpdateTaskAdapter {
    @Override
    public String[] getDependencies() {
        return new String[0];
    }

    @Override
    public TaskAttributes getAttributes() {
        return new Attributes(UpdateConcurrency.BLOCKING, WorkingLevel.SCHEMA);
    }

    @Override
    public void perform(PerformParameters params) throws OXException {
        org.apache.commons.logging.Log log = Log.loggerFor(InfostoreExtendFilenameTitleAndFilesizeTask.class);
        log.info((Object)("Performing update task " + InfostoreExtendFilenameTitleAndFilesizeTask.class.getSimpleName()));
        Column[] colums = new Column[]{new Column("title", "varchar(767)"), new Column("filename", "varchar(767)"), new Column("file_size", "bigint(20)")};
        Connection connnection = Database.getNoTimeout(params.getContextId(), true);
        try {
            connnection.setAutoCommit(false);
            Tools.checkAndModifyColumns(connnection, "infostore_document", colums);
            connnection.commit();
        }
        catch (SQLException e) {
            DBUtils.rollback(connnection);
            throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
        }
        catch (Exception e) {
            DBUtils.rollback(connnection);
            throw UpdateExceptionCodes.OTHER_PROBLEM.create(e, e.getMessage());
        }
        finally {
            DBUtils.autocommit(connnection);
            Database.backNoTimeout(params.getContextId(), true, connnection);
        }
        log.info((Object)(InfostoreExtendFilenameTitleAndFilesizeTask.class.getSimpleName() + " successfully performed."));
    }
}

