/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.tasks;

import com.openexchange.database.DatabaseService;
import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.Attributes;
import com.openexchange.groupware.update.PerformParameters;
import com.openexchange.groupware.update.TaskAttributes;
import com.openexchange.groupware.update.UpdateConcurrency;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTaskAdapter;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.tools.sql.DBUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class InfostoreClearDelTablesTask
extends UpdateTaskAdapter {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(InfostoreClearDelTablesTask.class));

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void perform(PerformParameters params) throws OXException {
        int contextId = params.getContextId();
        DatabaseService databaseService = ServerServiceRegistry.getInstance().getService(DatabaseService.class);
        Connection con = databaseService.getForUpdateTask(contextId);
        PreparedStatement stmt = null;
        try {
            con.setAutoCommit(false);
            LOG.info((Object)"Clearing obsolete fields in 'del_infostore_document'...");
            String query = "UPDATE del_infostore_document SET title = NULL, url = NULL, description = NULL, categories = NULL, filename = NULL, file_store_location = NULL, file_size = NULL, file_mimetype = NULL, file_md5sum = NULL, file_version_comment = NULL;";
            stmt = con.prepareStatement(query);
            int cleared = stmt.executeUpdate();
            LOG.info((Object)("Cleared " + cleared + " rows in 'del_infostore_document'."));
            con.commit();
        }
        catch (SQLException e) {
            try {
                DBUtils.rollback(con);
                throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
                catch (RuntimeException e2) {
                    DBUtils.rollback(con);
                    throw UpdateExceptionCodes.OTHER_PROBLEM.create(e2, e2.getMessage());
                }
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(stmt);
                DBUtils.autocommit(con);
                Database.backNoTimeout(contextId, true, con);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(stmt);
        DBUtils.autocommit(con);
        Database.backNoTimeout(contextId, true, con);
    }

    @Override
    public TaskAttributes getAttributes() {
        return new Attributes(UpdateConcurrency.BACKGROUND);
    }

    @Override
    public String[] getDependencies() {
        return new String[0];
    }
}

