/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.tasks;

import com.openexchange.database.DatabaseService;
import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.Attributes;
import com.openexchange.groupware.update.PerformParameters;
import com.openexchange.groupware.update.TaskAttributes;
import com.openexchange.groupware.update.UpdateConcurrency;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTaskAdapter;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.tools.sql.DBUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public final class FolderClearDelTablesTasks
extends UpdateTaskAdapter {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(FolderClearDelTablesTasks.class));

    @Override
    public String[] getDependencies() {
        return new String[0];
    }

    @Override
    public void perform(PerformParameters params) throws OXException {
        int contextID = params.getContextId();
        DatabaseService databaseService = ServerServiceRegistry.getInstance().getService(DatabaseService.class);
        Connection connection = databaseService.getForUpdateTask(contextID);
        boolean rollback = false;
        try {
            connection.setAutoCommit(false);
            rollback = true;
            LOG.info((Object)"Clearing obsolete fields in 'del_oxfolder_tree'...");
            int cleared = this.clearDelOxfolderTree(connection);
            LOG.info((Object)("Cleared " + cleared + " rows in 'del_oxfolder_tree'."));
            LOG.info((Object)"Clearing obsolete fields in 'virtualBackupTree'...");
            cleared = this.clearVirtuelBackupTree(connection);
            LOG.info((Object)("Cleared " + cleared + " rows in 'virtualBackupTree'."));
            connection.commit();
            rollback = false;
        }
        catch (SQLException e) {
            throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
        }
        catch (RuntimeException e) {
            throw UpdateExceptionCodes.OTHER_PROBLEM.create(e, e.getMessage());
        }
        finally {
            if (rollback) {
                DBUtils.rollback(connection);
            }
            DBUtils.autocommit(connection);
            Database.backNoTimeout(contextID, true, connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int clearDelOxfolderTree(Connection connection) throws SQLException {
        PreparedStatement statement = null;
        try {
            statement = connection.prepareStatement("UPDATE del_oxfolder_tree SET fname=?");
            statement.setString(1, "");
            int n = statement.executeUpdate();
            return n;
        }
        finally {
            DBUtils.closeSQLStuff(statement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int clearVirtuelBackupTree(Connection connection) throws SQLException {
        PreparedStatement statement = null;
        try {
            statement = connection.prepareStatement("UPDATE virtualBackupTree SET name=?");
            statement.setString(1, "");
            int n = statement.executeUpdate();
            return n;
        }
        finally {
            DBUtils.closeSQLStuff(statement);
        }
    }

    @Override
    public TaskAttributes getAttributes() {
        return new Attributes(UpdateConcurrency.BACKGROUND);
    }
}

