/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.tasks;

import com.openexchange.database.DatabaseService;
import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.Attributes;
import com.openexchange.groupware.update.PerformParameters;
import com.openexchange.groupware.update.TaskAttributes;
import com.openexchange.groupware.update.UpdateConcurrency;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTaskAdapter;
import com.openexchange.java.StringAllocator;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.tools.sql.DBUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public final class ContactClearDelTablesTasks
extends UpdateTaskAdapter {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(ContactClearDelTablesTasks.class));

    @Override
    public String[] getDependencies() {
        return new String[0];
    }

    @Override
    public void perform(PerformParameters params) throws OXException {
        int contextID = params.getContextId();
        DatabaseService databaseService = ServerServiceRegistry.getInstance().getService(DatabaseService.class);
        Connection connection = databaseService.getForUpdateTask(contextID);
        try {
            connection.setAutoCommit(false);
            LOG.info((Object)"Clearing obsolete fields in 'del_dlist'...");
            int cleared = ContactClearDelTablesTasks.clearDeletedDistributionLists(connection);
            LOG.info((Object)("Cleared " + cleared + " rows in 'del_dlist'."));
            LOG.info((Object)"Clearing obsolete fields in 'del_contacts_image'...");
            cleared = ContactClearDelTablesTasks.clearDeletedContactImages(connection);
            LOG.info((Object)("Cleared " + cleared + " rows in 'del_contacts_image'."));
            LOG.info((Object)"Clearing obsolete fields in 'del_contacts'...");
            cleared = ContactClearDelTablesTasks.clearDeletedContacts(connection);
            LOG.info((Object)("Cleared " + cleared + " rows in 'del_contacts'."));
            connection.commit();
        }
        catch (SQLException e) {
            DBUtils.rollback(connection);
            throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
        }
        catch (RuntimeException e) {
            DBUtils.rollback(connection);
            throw UpdateExceptionCodes.OTHER_PROBLEM.create(e, e.getMessage());
        }
        finally {
            DBUtils.autocommit(connection);
            Database.backNoTimeout(contextID, true, connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int clearDeletedContacts(Connection connection) throws SQLException {
        int n;
        String[] columsToClear = new String[]{"timestampfield01", "timestampfield02", "intfield02", "intfield03", "intfield04", "intfield05", "intfield06", "intfield07", "intfield08", "field01", "field02", "field03", "field04", "field05", "field06", "field07", "field08", "field09", "field10", "field11", "field12", "field13", "field14", "field15", "field16", "field17", "field18", "field19", "field20", "field21", "field22", "field23", "field24", "field25", "field26", "field27", "field28", "field29", "field30", "field31", "field32", "field33", "field34", "field35", "field36", "field37", "field38", "field39", "field40", "field41", "field42", "field43", "field44", "field45", "field46", "field47", "field48", "field49", "field50", "field51", "field52", "field53", "field54", "field55", "field56", "field57", "field58", "field59", "field60", "field61", "field62", "field63", "field64", "field65", "field66", "field67", "field68", "field69", "field70", "field71", "field72", "field73", "field74", "field75", "field76", "field77", "field78", "field79", "field80", "field81", "field82", "field83", "field84", "field85", "field86", "field87", "field88", "field89", "field90", "useCount", "yomiFirstName", "yomiLastName", "yomiCompany", "homeAddress", "businessAddress", "otherAddress"};
        StringAllocator stringAllocator = new StringAllocator("UPDATE del_contacts SET ").append(columsToClear[0]).append("=NULL");
        for (int i = 1; i < columsToClear.length; ++i) {
            stringAllocator.append(',').append(columsToClear[i]).append("=NULL");
        }
        stringAllocator.append(';');
        PreparedStatement statement = null;
        try {
            statement = connection.prepareStatement(stringAllocator.toString());
            n = statement.executeUpdate();
        }
        catch (Throwable throwable) {
            DBUtils.closeSQLStuff(statement);
            throw throwable;
        }
        DBUtils.closeSQLStuff(statement);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int clearDeletedDistributionLists(Connection connection) throws SQLException {
        PreparedStatement statement = null;
        try {
            statement = connection.prepareStatement("DELETE FROM del_dlist;");
            int n = statement.executeUpdate();
            return n;
        }
        finally {
            DBUtils.closeSQLStuff(statement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int clearDeletedContactImages(Connection connection) throws SQLException {
        PreparedStatement statement = null;
        try {
            statement = connection.prepareStatement("DELETE FROM del_contacts_image;");
            int n = statement.executeUpdate();
            return n;
        }
        finally {
            DBUtils.closeSQLStuff(statement);
        }
    }

    @Override
    public TaskAttributes getAttributes() {
        return new Attributes(UpdateConcurrency.BACKGROUND);
    }
}

