/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update;

import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.PerformParameters;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTaskAdapter;
import com.openexchange.tools.sql.DBUtils;
import java.sql.Connection;
import java.sql.SQLException;

public abstract class SimpleUpdateTask
extends UpdateTaskAdapter {
    @Override
    public final void perform(PerformParameters params) throws OXException {
        int contextId = params.getContextId();
        Connection con = Database.getNoTimeout(contextId, true);
        try {
            DBUtils.startTransaction(con);
            if (!this.shouldRun(con)) {
                return;
            }
            this.perform(con);
            con.commit();
        }
        catch (SQLException e) {
            DBUtils.rollback(con);
            throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
        }
        finally {
            DBUtils.autocommit(con);
            Database.backNoTimeout(contextId, true, con);
        }
    }

    protected abstract void perform(Connection var1) throws SQLException;

    protected boolean shouldRun(Connection con) {
        return true;
    }

    @Override
    public String[] getDependencies() {
        return new String[0];
    }
}

