/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.tasks;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.container.Participant;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.downgrade.DowngradeEvent;
import com.openexchange.groupware.downgrade.DowngradeListener;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.tasks.Folder;
import com.openexchange.groupware.tasks.FolderStorage;
import com.openexchange.groupware.tasks.ParticipantStorage;
import com.openexchange.groupware.tasks.StorageType;
import com.openexchange.groupware.tasks.Task;
import com.openexchange.groupware.tasks.TaskExceptionCode;
import com.openexchange.groupware.tasks.TaskLogic;
import com.openexchange.groupware.tasks.Tools;
import com.openexchange.groupware.tasks.UpdateData;
import com.openexchange.groupware.userconfiguration.UserPermissionBits;
import com.openexchange.log.LogFactory;
import com.openexchange.server.impl.OCLPermission;
import com.openexchange.session.Session;
import com.openexchange.tools.iterator.SearchIterator;
import com.openexchange.tools.oxfolder.OXFolderIteratorSQL;
import java.sql.Connection;
import java.util.Date;
import java.util.Set;
import org.apache.commons.logging.Log;

public class TasksDowngrade
extends DowngradeListener {
    private static final Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(TasksDowngrade.class));
    private static final ParticipantStorage partStor = ParticipantStorage.getInstance();
    private static FolderStorage foldStor = FolderStorage.getInstance();

    @Override
    public void downgradePerformed(DowngradeEvent event) throws OXException {
        UserPermissionBits permissionBits = event.getNewUserConfiguration().getUserPermissionBits();
        Session session = event.getSession();
        Context ctx = event.getContext();
        Connection con = event.getWriteCon();
        if (!permissionBits.hasTask()) {
            this.removeTasks(session, ctx, permissionBits.getUserId(), con);
        }
        if (!permissionBits.canDelegateTasks()) {
            this.removeDelegations(session, ctx, permissionBits.getUserId(), permissionBits, con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeTasks(Session session, Context ctx, int userId, Connection con) throws OXException {
        FolderObject folder;
        User user = Tools.getUser(ctx, userId);
        SearchIterator<FolderObject> iter = OXFolderIteratorSQL.getAllVisibleFoldersIteratorOfType(userId, user.getGroups(), new int[]{1}, 1, new int[]{1}, ctx);
        try {
            while (iter.hasNext()) {
                folder = (FolderObject)iter.next();
                this.removeTaskInPrivateFolder(session, ctx, con, userId, folder);
            }
        }
        finally {
            iter.close();
        }
        for (StorageType type : StorageType.TYPES_AD) {
            int[] taskIds;
            for (int taskId : taskIds = partStor.findTasksWithParticipant(ctx, con, userId, type)) {
                Folder folder2;
                partStor.deleteInternal(ctx, con, taskId, userId, type, true);
                Set<Folder> folders2 = foldStor.selectFolder(ctx, con, taskId, type);
                if (0 == folders2.size()) {
                    throw TaskExceptionCode.MISSING_FOLDER.create(taskId);
                }
                if (folders2.size() > 1) {
                    folder2 = FolderStorage.extractFolderOfUser(folders2, userId);
                    if (null == folder2) continue;
                    foldStor.deleteFolder(ctx, con, taskId, folder2.getIdentifier(), type);
                    continue;
                }
                if (ctx.getMailadmin() == userId) {
                    folder2 = folders2.iterator().next();
                    TaskLogic.removeTask(session, ctx, con, folder2.getIdentifier(), taskId, type);
                    continue;
                }
                folder2 = folders2.iterator().next();
                foldStor.deleteFolder(ctx, con, taskId, folder2.getIdentifier(), type);
                folder2 = new Folder(folder2.getIdentifier(), ctx.getMailadmin());
                foldStor.insertFolder(ctx, con, taskId, folder2, type);
            }
        }
        iter = OXFolderIteratorSQL.getAllVisibleFoldersIteratorOfType(userId, user.getGroups(), new int[]{1}, 2, new int[]{1}, ctx);
        try {
            while (iter.hasNext()) {
                folder = (FolderObject)iter.next();
                OCLPermission[] ocls = folder.getPermissionsAsArray();
                boolean other = false;
                for (int i = 0; i < ocls.length && !other; ++i) {
                    OCLPermission perm = ocls[i];
                    if (perm.getEntity() == userId || !perm.canWriteAllObjects()) continue;
                    other = true;
                }
                if (other) continue;
                this.removeTaskInFolder(session, ctx, con, folder);
            }
        }
        finally {
            iter.close();
        }
    }

    private void removeTaskInPrivateFolder(Session session, Context ctx, Connection con, int userId, FolderObject folder) throws OXException {
        for (StorageType type : StorageType.TYPES_AD) {
            int[] taskIds;
            for (int taskId : taskIds = foldStor.getTasksInFolder(ctx, con, folder.getObjectID(), type)) {
                Set<Folder> folders2 = foldStor.selectFolder(ctx, con, taskId, type);
                if (0 == folders2.size()) {
                    throw TaskExceptionCode.MISSING_FOLDER.create(taskId);
                }
                if (folders2.size() > 1) {
                    int folderId = FolderStorage.extractFolderOfUser(folders2, userId).getIdentifier();
                    foldStor.deleteFolder(ctx, con, taskId, folderId, type);
                    partStor.deleteInternal(ctx, con, taskId, userId, type, false);
                    continue;
                }
                TaskLogic.removeTask(session, ctx, con, folder.getObjectID(), taskId, type);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeDelegations(Session session, Context ctx, int userId, UserPermissionBits permissionBits, Connection con) throws OXException {
        FolderObject folder;
        User user = Tools.getUser(ctx, userId);
        SearchIterator<FolderObject> iter = OXFolderIteratorSQL.getAllVisibleFoldersIteratorOfType(userId, user.getGroups(), new int[]{1}, 1, new int[]{1}, ctx);
        try {
            while (iter.hasNext()) {
                folder = (FolderObject)iter.next();
                this.removeDelegationsInFolder(session, ctx, permissionBits, con, user, folder);
            }
        }
        finally {
            iter.close();
        }
        iter = OXFolderIteratorSQL.getAllVisibleFoldersIteratorOfType(userId, user.getGroups(), new int[]{1}, 2, new int[]{1}, ctx);
        try {
            while (iter.hasNext()) {
                folder = (FolderObject)iter.next();
                OCLPermission[] ocls = folder.getPermissionsAsArray();
                boolean other = false;
                for (int i = 0; i < ocls.length && !other; ++i) {
                    OCLPermission perm = ocls[i];
                    if (perm.getEntity() == userId || !perm.canWriteAllObjects()) continue;
                    other = true;
                }
                if (other) continue;
                this.removeDelegationsInFolder(session, ctx, permissionBits, con, user, folder);
            }
        }
        finally {
            iter.close();
        }
    }

    private void removeTaskInFolder(Session session, Context ctx, Connection con, FolderObject folder) throws OXException {
        for (StorageType type : StorageType.TYPES_AD) {
            int[] taskIds;
            for (int taskId : taskIds = foldStor.getTasksInFolder(ctx, con, folder.getObjectID(), type)) {
                TaskLogic.removeTask(session, ctx, con, folder.getObjectID(), taskId, type);
            }
        }
    }

    private void removeDelegationsInFolder(Session session, Context ctx, UserPermissionBits permissionBits, Connection con, User user, FolderObject folder) throws OXException {
        for (StorageType type : StorageType.TYPES_AD) {
            int[] taskIds;
            for (int taskId : taskIds = foldStor.getTasksInFolder(ctx, con, folder.getObjectID(), type)) {
                Task task = new Task();
                task.setObjectID(taskId);
                task.setParentFolderID(folder.getObjectID());
                task.setParticipants(new Participant[0]);
                UpdateData update = new UpdateData(ctx, user, permissionBits, folder, task, new Date(), type);
                update.prepareWithoutChecks();
                update.doUpdate();
                if (StorageType.ACTIVE != type) continue;
                update.sentEvent(session);
                try {
                    update.updateReminder();
                }
                catch (OXException e) {
                    LOG.error((Object)"Problem while updating reminder for a task.", (Throwable)e);
                }
            }
        }
    }

    @Override
    public int getOrder() {
        return 3;
    }
}

