/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.tasks;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.tasks.Folder;
import com.openexchange.groupware.tasks.FolderStorage;
import com.openexchange.groupware.tasks.Permission;
import com.openexchange.groupware.tasks.StorageType;
import com.openexchange.groupware.tasks.Task;
import com.openexchange.groupware.tasks.TaskStorage;
import com.openexchange.groupware.tasks.Tools;
import com.openexchange.groupware.userconfiguration.UserPermissionBits;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.session.Session;
import java.util.Set;

public final class Task2Links {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(Task2Links.class));

    private Task2Links() {
    }

    public static boolean checkMayReadTask(Session session, Context ctx, UserPermissionBits permissionBits, int taskId) {
        Set<Folder> folders2;
        Task task;
        User user;
        try {
            user = Tools.getUser(ctx, session.getUserId());
            TaskStorage storage = TaskStorage.getInstance();
            task = storage.selectTask(ctx, taskId, StorageType.ACTIVE);
            folders2 = FolderStorage.getInstance().selectFolder(ctx, taskId, StorageType.ACTIVE);
        }
        catch (OXException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
        for (Folder folder : folders2) {
            if (!Task2Links.mayRead(ctx, user, permissionBits, task, folder)) continue;
            return true;
        }
        return false;
    }

    public static boolean checkMayReadTask(Session session, Context ctx, UserPermissionBits permissionBits, int taskId, int folderId) {
        Folder folder;
        Task task;
        User user;
        try {
            user = Tools.getUser(ctx, session.getUserId());
            TaskStorage storage = TaskStorage.getInstance();
            task = storage.selectTask(ctx, taskId, StorageType.ACTIVE);
            folder = FolderStorage.getInstance().selectFolderById(ctx, taskId, folderId, StorageType.ACTIVE);
        }
        catch (OXException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
        return null == folder ? false : Task2Links.mayRead(ctx, user, permissionBits, task, folder);
    }

    private static boolean mayRead(Context ctx, User user, UserPermissionBits permissionBits, Task task, Folder folder) {
        FolderObject folder2;
        try {
            folder2 = Tools.getFolder(ctx, folder.getIdentifier());
        }
        catch (OXException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
        try {
            Permission.isFolderVisible(ctx, user, permissionBits, folder2);
            Permission.canReadInFolder(ctx, user, permissionBits, folder2, task);
            return true;
        }
        catch (OXException e) {
            return false;
        }
    }
}

